/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.iterators;

import com.atlassian.fecru.iterators.ListSkippableWithSizeIterator;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;

public class ListSkippableWithSizeIteratorTest {
    private ListSkippableWithSizeIterator<Integer> skipIt;

    @Before
    public void before() {
        this.skipIt = ListSkippableWithSizeIterator.from(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
    }

    @Test
    public void testSkip0() throws Exception {
        this.skipIt.skip(0);
        MatcherAssert.assertThat((Object)Lists.newArrayList(this.skipIt), (Matcher)Matchers.hasItems((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testSkip5() throws Exception {
        this.skipIt.skip(5);
        MatcherAssert.assertThat((Object)Lists.newArrayList(this.skipIt), (Matcher)Matchers.hasItems((Object[])new Integer[]{5, 6, 7, 8, 9}));
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testSkip10() throws Exception {
        this.skipIt.skip(10);
        MatcherAssert.assertThat((Object)Lists.newArrayList(this.skipIt), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testSkip15() throws Exception {
        int result = this.skipIt.skip(15);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)10));
        MatcherAssert.assertThat((Object)Lists.newArrayList(this.skipIt), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testHasNextTrue() throws Exception {
        this.skipIt.skip(9);
        MatcherAssert.assertThat((Object)this.skipIt.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testHasNextFalse() throws Exception {
        this.skipIt.skip(10);
        MatcherAssert.assertThat((Object)this.skipIt.hasNext(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testNext5() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.skipIt.next();
        }
        MatcherAssert.assertThat((Object)Lists.newArrayList(this.skipIt), (Matcher)Matchers.hasItems((Object[])new Integer[]{5, 6, 7, 8, 9}));
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testNext10() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.skipIt.next();
        }
        MatcherAssert.assertThat((Object)Lists.newArrayList(this.skipIt), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test(expected=NoSuchElementException.class)
    public void testNext11() throws Exception {
        for (int i = 0; i < 11; ++i) {
            this.skipIt.next();
        }
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void testRemove5() throws Exception {
        LinkedList main = Lists.newLinkedList(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        this.skipIt = ListSkippableWithSizeIterator.from((List)main);
        for (int i = 0; this.skipIt.hasNext() && i < 5; ++i) {
            this.skipIt.next();
            this.skipIt.remove();
        }
        MatcherAssert.assertThat((Object)main, (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)main, (Matcher)Matchers.hasItems((Object[])new Integer[]{5, 6, 7, 8, 9}));
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveUnsupported() throws Exception {
        this.skipIt = ListSkippableWithSizeIterator.from(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        for (int i = 0; this.skipIt.hasNext() && i < 5; ++i) {
            this.skipIt.next();
            this.skipIt.remove();
        }
        MatcherAssert.assertThat((Object)this.skipIt.size(), (Matcher)Is.is((Object)10));
    }
}

