/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.webitems.server;

import com.atlassian.fecru.gwt.webitems.server.WebSectionsServerSerializer;
import com.cenqua.fisheye.web.webfragments.WebItemData;
import com.cenqua.fisheye.web.webfragments.WebSectionData;
import java.util.Collections;
import junit.framework.TestCase;

public class WebSectionsServerSerializerTest
extends TestCase {
    public void testCanStoreNullList() throws Exception {
        WebSectionsServerSerializerTest.assertEquals((String)"[]", (String)WebSectionsServerSerializer.serialize(null));
    }

    public void testCanStoreEmptyList() throws Exception {
        WebSectionsServerSerializerTest.assertEquals((String)"[]", (String)WebSectionsServerSerializer.serialize(Collections.emptyList()));
    }

    public void testCanStoreSingleSectionWithNoWebItems() throws Exception {
        String result = WebSectionsServerSerializer.serialize(Collections.singletonList(new WebSectionData("a", "b", "c", "d", Collections.emptyList())));
        WebSectionsServerSerializerTest.assertEquals((String)"[{\\\"name\\\":\\\"a\\\",\\\"key\\\":\\\"b\\\",\\\"location\\\":\\\"c\\\",\\\"labelText\\\":\\\"d\\\",\\\"items\\\":[]}]", (String)result);
    }

    public void testCanStoreSingleSectionWithOneWebItem() throws Exception {
        String result = WebSectionsServerSerializer.serialize(Collections.singletonList(new WebSectionData("a", "b", "c", "d", Collections.singletonList(new WebItemData("a", "b", "c", "d", "e", 1, 2, "f", Collections.singletonMap("pageName", "g"))))));
        WebSectionsServerSerializerTest.assertEquals((String)"[{\\\"name\\\":\\\"a\\\",\\\"key\\\":\\\"b\\\",\\\"location\\\":\\\"c\\\",\\\"labelText\\\":\\\"d\\\",\\\"items\\\":[{\\\"url\\\":\\\"a\\\",\\\"moduleKey\\\":\\\"b\\\",\\\"linkText\\\":\\\"c\\\",\\\"tooltip\\\":\\\"d\\\",\\\"iconUrl\\\":\\\"e\\\",\\\"iconWidth\\\":1,\\\"iconHeight\\\":2,\\\"styleClass\\\":\\\"f\\\",\\\"params\\\":{\\\"pageName\\\":\\\"g\\\"}}]}]", (String)result);
    }
}

