/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.servlet;

import com.atlassian.fecru.gwt.servlet.GwtRPCRequestTracker;
import com.atlassian.fecru.gwt.servlet.GwtRPCRoutingServlet;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.cenqua.fisheye.config.SpringContext;
import com.google.common.collect.ImmutableMap;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RpcToken;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.XsrfToken;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.XsrfProtect;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public final class GwtRPCRoutingServletTest {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private StaticApplicationContext context;
    private Method methodHello;
    private Method methodXsrf;
    private ServletContext servletContext;

    @Before
    public void setUp() throws Exception {
        this.context = new StaticApplicationContext();
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        ((ServletContext)Mockito.doAnswer(invocationOnMock -> null).when((Object)this.servletContext)).log(Mockito.anyString(), (Throwable)org.mockito.Matchers.anyObject());
        this.methodHello = MyGwtService.class.getMethod("hello", String.class);
        this.methodXsrf = MyGwtService.class.getMethod("xsrf", String.class);
    }

    @After
    public void tearDown() throws Exception {
        SpringContext.setApplicationContext(null);
    }

    private void addBeansToContext(Map<String, Class> beans) {
        for (Map.Entry<String, Class> bean : beans.entrySet()) {
            this.context.registerSingleton(bean.getKey(), bean.getValue());
        }
        this.context.refresh();
        SpringContext.setApplicationContext((ApplicationContext)this.context);
    }

    @Test
    public void testRequestTrackersNotified() {
        this.addBeansToContext((Map<String, Class>)ImmutableMap.of((Object)"requestTracker", RecordingRequestTracker.class));
        new GwtRPCRoutingServlet().notifyRequestTrackers(this.request, this.response);
        new GwtRPCRoutingServlet().clearRequestTrackers(this.request, this.response);
        RecordingRequestTracker tracker = (RecordingRequestTracker)this.context.getBean("requestTracker");
        Assert.assertTrue((boolean)tracker.onStartedCalled);
        Assert.assertTrue((boolean)tracker.onEndedCalled);
    }

    @Test
    public void testNoRouteFound() throws NoSuchMethodException, SerializationException {
        this.addBeansToContext((Map<String, Class>)ImmutableMap.of());
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"nosuchservice");
        TestingGwtRPCRoutingServlet servlet = new TestingGwtRPCRoutingServlet(this.request, this.response, this.servletContext, this.methodHello);
        String result = servlet.processCall("nada");
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"Could not find service for path info nosuchservice"));
    }

    @Test
    public void testRequestsRouted() throws NoSuchMethodException, SerializationException {
        this.addBeansToContext((Map<String, Class>)ImmutableMap.of((Object)"mygwtservice", MyGwtService.class));
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"mygwtservice");
        TestingGwtRPCRoutingServlet servlet = new TestingGwtRPCRoutingServlet(this.request, this.response, this.servletContext, this.methodHello);
        String result = servlet.processCall("world");
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"Hello, world!"));
    }

    @Test
    public void testXsrfExpectedTokenMissing() throws NoSuchMethodException, SerializationException {
        String result = this.processCallXsrf(null, "0987654321");
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"Invalid RPC token"));
    }

    @Test
    public void testXsrfActualTokenMissing() throws NoSuchMethodException, SerializationException {
        String result = this.processCallXsrf("1234567890", null);
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"Invalid RPC token"));
    }

    @Test
    public void testXsrfInvalidToken() throws NoSuchMethodException, SerializationException {
        String result = this.processCallXsrf("1234567890", "0987654321");
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"Invalid RPC token"));
    }

    @Test
    public void testXsrfValidToken() throws NoSuchMethodException, SerializationException {
        String result = this.processCallXsrf("1234567890", "1234567890");
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"xsrf:world"));
    }

    private String processCallXsrf(String expectedToken, String actualToken) throws NoSuchMethodException, SerializationException {
        this.addBeansToContext((Map<String, Class>)ImmutableMap.of((Object)"mygwtservice", MyGwtService.class, (Object)"xsrfTokenAccessor", StaticXsrfTokenAccessor.class));
        StaticXsrfTokenAccessor.token = expectedToken;
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"mygwtservice");
        TestingGwtRPCRoutingServlet servlet = new TestingGwtRPCRoutingServlet(this.request, this.response, this.servletContext, this.methodXsrf, actualToken);
        return servlet.processCall("world");
    }

    public static class TestingSerializationPolicy
    extends SerializationPolicy {
        public boolean shouldDeserializeFields(Class<?> clazz) {
            return true;
        }

        public boolean shouldSerializeFields(Class<?> clazz) {
            return true;
        }

        public void validateDeserialize(Class<?> clazz) throws SerializationException {
        }

        public void validateSerialize(Class<?> clazz) throws SerializationException {
        }
    }

    public static class RecordingRequestTracker
    implements GwtRPCRequestTracker {
        public boolean onStartedCalled = false;
        public boolean onEndedCalled = false;

        public void onRequestStarted(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
            this.onStartedCalled = true;
        }

        public void onRequestEnded(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
            this.onEndedCalled = true;
        }
    }

    public static class StaticXsrfTokenAccessor
    implements XsrfTokenAccessor {
        public static String token;

        public String getXsrfToken(HttpServletRequest request, HttpServletResponse response, boolean create) {
            return token;
        }
    }

    public static class MyGwtService
    implements RemoteService {
        public String hello(String target) {
            return "Hello, " + target + "!";
        }

        @XsrfProtect
        public String xsrf(String target) {
            return "xsrf:" + target;
        }
    }

    static class TestingGwtRPCRoutingServlet
    extends GwtRPCRoutingServlet {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final ServletContext servletContext;
        private final Method method;
        private final XsrfToken rpcToken;

        TestingGwtRPCRoutingServlet(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Method method, String rpcToken) {
            this.request = request;
            this.response = response;
            this.servletContext = servletContext;
            this.method = method;
            this.rpcToken = rpcToken == null ? null : new XsrfToken(rpcToken);
        }

        TestingGwtRPCRoutingServlet(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Method method) {
            this(request, response, servletContext, method, null);
        }

        protected HttpServletRequest getCurrentRequest() {
            return this.request;
        }

        protected HttpServletResponse getCurrentResponse() {
            return this.response;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        protected RPCRequest decodeRequest(String payload) {
            return new RPCRequest(this.method, new Object[]{payload}, (RpcToken)this.rpcToken, (SerializationPolicy)new TestingSerializationPolicy(), 0);
        }

        public String getServletName() {
            return GwtRPCRoutingServlet.class.getName();
        }

        protected String encodeFailure(Throwable ex) throws SerializationException {
            return ex.getMessage();
        }
    }
}

