/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.cscomment.client.ui;

import com.atlassian.fecru.gwt.GwtTestUtils;
import com.atlassian.fecru.gwt.comments.client.ui.CommentRPCService;
import com.atlassian.fecru.gwt.comments.client.ui.CommentViewPresenter;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentAddedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.CommentDeletedEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.EditCommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.EditCommentEventHandler;
import com.atlassian.fecru.gwt.comments.client.ui.events.EndEditCommentEvent;
import com.atlassian.fecru.gwt.comments.client.ui.events.EndEditCommentEventHandler;
import com.atlassian.fecru.gwt.comments.shared.CommentModel;
import com.atlassian.fecru.gwt.comments.shared.UserModel;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.HasHTML;
import java.util.Date;
import junit.framework.TestCase;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CommentFormPresenterTest
extends TestCase {
    private CommentRPCService rpcService;
    private HandlerManager eventBus;
    private CommentViewPresenter presenter;
    private CommentViewPresenter.Display display;
    private ArgumentCaptor<CommentAddedEventHandler> addedHandler;
    private ArgumentCaptor<EditCommentEventHandler> editHandler;
    private ArgumentCaptor<EndEditCommentEventHandler> editEndHandler;
    private ArgumentCaptor<CommentDeletedEventHandler> deletedHandler;
    private GwtTestUtils.MockHasClickHandlers editClickHandler;
    private GwtTestUtils.MockHasClickHandlers replyClickHandler;
    private GwtTestUtils.MockHasClickHandlers deleteClickHandler;
    private GwtTestUtils.MockHasClickHandlers postClickHandler;
    private String bodyHtml;

    protected void setUp() throws Exception {
        this.rpcService = (CommentRPCService)Mockito.mock(CommentRPCService.class);
        this.eventBus = (HandlerManager)Mockito.mock(HandlerManager.class);
        this.display = (CommentViewPresenter.Display)Mockito.mock(CommentViewPresenter.Display.class);
        this.editClickHandler = new GwtTestUtils.MockHasClickHandlers();
        this.replyClickHandler = new GwtTestUtils.MockHasClickHandlers();
        this.deleteClickHandler = new GwtTestUtils.MockHasClickHandlers();
        this.postClickHandler = new GwtTestUtils.MockHasClickHandlers();
        Mockito.when((Object)this.display.getBody()).thenReturn((Object)this.newBody());
        Mockito.when((Object)this.display.getEditButton()).thenReturn((Object)this.editClickHandler);
        Mockito.when((Object)this.display.getReplyButton()).thenReturn((Object)this.replyClickHandler);
        Mockito.when((Object)this.display.getDeleteButton()).thenReturn((Object)this.deleteClickHandler);
        Mockito.when((Object)this.display.getPostButton()).thenReturn((Object)this.postClickHandler);
        this.addedHandler = GwtTestUtils.captureEventHandler(CommentAddedEvent.TYPE, CommentAddedEventHandler.class, this.eventBus);
        this.deletedHandler = GwtTestUtils.captureEventHandler(CommentDeletedEvent.TYPE, CommentDeletedEventHandler.class, this.eventBus);
        this.editHandler = GwtTestUtils.captureEventHandler(EditCommentEvent.TYPE, EditCommentEventHandler.class, this.eventBus);
        this.editEndHandler = GwtTestUtils.captureEventHandler(EndEditCommentEvent.TYPE, EndEditCommentEventHandler.class, this.eventBus);
        this.presenter = this.createCVP(null, 1);
    }

    public void testCommentsWithRepliesCantBeDeleted() {
        ((CommentAddedEventHandler)this.addedHandler.getValue()).onCommentAddedEvent(new CommentAddedEvent(Integer.valueOf(1), Integer.valueOf(2), this.makeComment(2)));
        ((CommentViewPresenter.Display)Mockito.verify((Object)this.display)).enableDeleteButton(false);
        Mockito.reset((Object[])new CommentViewPresenter.Display[]{this.display});
        ((CommentDeletedEventHandler)this.deletedHandler.getValue()).onCommentDeletedEvent(new CommentDeletedEvent(Integer.valueOf(1), 2));
        ((CommentViewPresenter.Display)Mockito.verify((Object)this.display)).enableDeleteButton(true);
    }

    public void testButtonsAreEnabledAndDisabledCorrectly() throws Exception {
        ((EditCommentEventHandler)this.editHandler.getValue()).onEditCommentEvent(new EditCommentEvent(null, Integer.valueOf(2), this.makeComment(1), null, false));
        ((CommentViewPresenter.Display)Mockito.verify((Object)this.display, (VerificationMode)Mockito.atLeast((int)1))).enableEditButton(false);
        ((CommentViewPresenter.Display)Mockito.verify((Object)this.display, (VerificationMode)Mockito.atLeast((int)1))).enableDeleteButton(false);
        ((CommentViewPresenter.Display)Mockito.verify((Object)this.display, (VerificationMode)Mockito.atLeast((int)1))).enableReplyButton(false);
        ((EndEditCommentEventHandler)this.editEndHandler.getValue()).onEndEditCommentEvent(new EndEditCommentEvent(true, Integer.valueOf(2), Integer.valueOf(-1), this.makeComment(1)));
        ((CommentViewPresenter.Display)Mockito.verify((Object)this.display, (VerificationMode)Mockito.atLeast((int)1))).enableEditButton(true);
        ((CommentViewPresenter.Display)Mockito.verify((Object)this.display, (VerificationMode)Mockito.atLeast((int)1))).enableDeleteButton(true);
        ((CommentViewPresenter.Display)Mockito.verify((Object)this.display, (VerificationMode)Mockito.atLeast((int)1))).enableReplyButton(true);
    }

    private CommentModel makeComment(int id) {
        return new CommentModel(id, "Comment Text", "Comment Text", new UserModel("", "fred", "", ""), new Date(), true, true, false, false);
    }

    private CommentViewPresenter<CommentModel> createCVP(Integer parentId, Integer id) {
        return new CommentViewPresenter(parentId, id, this.makeComment(id), this.rpcService, this.eventBus, this.display, 0);
    }

    private HasHTML newBody() {
        return new HasHTML(){

            public String getHTML() {
                return CommentFormPresenterTest.this.bodyHtml;
            }

            public void setHTML(String html) {
                CommentFormPresenterTest.this.bodyHtml = html;
            }

            public String getText() {
                return "";
            }

            public void setText(String text) {
            }
        };
    }
}

