/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.core.client;

import com.atlassian.fecru.gwt.core.client.BaseAsyncCallback;
import com.atlassian.fecru.gwt.core.client.Spinner;
import com.atlassian.fecru.gwt.core.shared.HumanReadableError;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class BaseAsyncCallbackTest
extends TestCase {
    public void testSpinnerStoppedAndStartedOnSuccess() {
        LinkedList<Boolean> spinnerStates = new LinkedList<Boolean>();
        Spinner spinner = this.newSpinner(spinnerStates);
        BaseAsyncCallback<Void> async = new BaseAsyncCallback<Void>(spinner){

            protected void success(Void result) {
            }
        };
        async.onSuccess(null);
    }

    public void testSpinnerStoppedAndStartedOnFailure() {
        LinkedList<Boolean> spinnerStates = new LinkedList<Boolean>();
        Spinner spinner = this.newSpinner(spinnerStates);
        BaseAsyncCallback<Void> async = new BaseAsyncCallback<Void>(spinner){

            protected void success(Void result) {
            }

            protected void failure(Throwable caught) {
            }
        };
        async.onFailure((Throwable)new RuntimeException());
    }

    public void testHumanReadableErrorsAreShown() {
        final String[] humanReadableErrorShown = new String[]{null};
        BaseAsyncCallback<Void> async = new BaseAsyncCallback<Void>(){

            protected void success(Void result) {
            }

            protected void reportHumanReadableError(HumanReadableError caught) {
                humanReadableErrorShown[0] = caught.getHumanReadableError();
            }
        };
        class MyHumanReadableError
        extends Exception
        implements HumanReadableError {
            MyHumanReadableError(String message) {
                super(message);
            }

            public String getHumanReadableError() {
                return this.getMessage();
            }
        }
        async.onFailure((Throwable)new MyHumanReadableError("foobar"));
        BaseAsyncCallbackTest.assertEquals((String)"foobar", (String)humanReadableErrorShown[0]);
    }

    public void testNonHumanReadableErrorsAreShown() {
        final String[] errroMessage = new String[]{null};
        BaseAsyncCallback<Void> async = new BaseAsyncCallback<Void>(){

            protected void success(Void result) {
            }

            protected void reportError(Throwable caught) {
                errroMessage[0] = caught.getMessage();
            }
        };
        async.onFailure((Throwable)new RuntimeException("foobar"));
        BaseAsyncCallbackTest.assertEquals((String)"foobar", (String)errroMessage[0]);
    }

    private Spinner newSpinner(List<Boolean> spinnerStates) {
        Spinner spinner = (Spinner)Mockito.mock(Spinner.class);
        ((Spinner)Mockito.doAnswer(invocationOnMock -> {
            spinnerStates.add((Boolean)invocationOnMock.getArguments()[0]);
            return null;
        }).when((Object)spinner)).showSpinner(Mockito.anyBoolean());
        return spinner;
    }
}

