/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.validation;

import com.atlassian.fecru.gwt.admin.shared.validation.ValidationException;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import java.util.Collections;
import junit.framework.TestCase;

public class ValidatorTest
extends TestCase {
    public void testIsEmptyOrNull() throws Exception {
        ValidatorTest.assertTrue((boolean)Validator.Utils.isEmptyOrNull(null));
        ValidatorTest.assertTrue((boolean)Validator.Utils.isEmptyOrNull((String)""));
        ValidatorTest.assertFalse((boolean)Validator.Utils.isEmptyOrNull((String)"foo"));
    }

    public void testEnsure() throws Exception {
        ValidationMessages validationMessages = new ValidationMessages();
        Validator.Utils.ensure((boolean)true, (String)"id1", (String)"message", (ValidationMessages)validationMessages);
        Validator.Utils.ensure((boolean)false, (String)"id2", (String)"message", (ValidationMessages)validationMessages);
        ValidatorTest.assertNull((Object)validationMessages.getFor("id1"));
        ValidatorTest.assertNotNull((Object)validationMessages.getFor("id2"));
    }

    public void testEnsureNotEmptyOrNull() throws Exception {
        ValidationMessages validationMessages = new ValidationMessages();
        Validator.Utils.ensureNotEmptyOrNull((String)"", (String)"id1", (String)"message", (ValidationMessages)validationMessages);
        Validator.Utils.ensureNotEmptyOrNull(null, (String)"id2", (String)"message", (ValidationMessages)validationMessages);
        Validator.Utils.ensureNotEmptyOrNull((String)"notnull", (String)"id2", (String)"message", (ValidationMessages)validationMessages);
        ValidatorTest.assertNotNull((Object)validationMessages.getFor("id1"));
        ValidatorTest.assertNotNull((Object)validationMessages.getFor("id2"));
        ValidatorTest.assertNull((Object)validationMessages.getFor("id3"));
    }

    public void testThrowIfNotEmpty() throws Exception {
        try {
            Validator.Utils.throwIfNotEmpty((ValidationMessages)new ValidationMessages(Collections.singletonList(new ValidationMessage("id", "message"))));
            ValidatorTest.fail();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        try {
            Validator.Utils.throwIfNotEmpty((ValidationMessages)new ValidationMessages(Collections.emptyList()));
        }
        catch (ValidationException e) {
            ValidatorTest.fail();
        }
    }
}

