/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.validation;

import com.atlassian.fecru.gwt.admin.shared.validation.ValidationException;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidatorChain;
import junit.framework.TestCase;

public class ValidatorChainTest
extends TestCase {
    private Validator<String> validator1;
    private Validator<String> validator2;

    protected void setUp() throws Exception {
        this.validator1 = (s, messages) -> {
            messages.addMessage(new ValidationMessage("validator1:" + s, s));
            return messages;
        };
        this.validator2 = (s, messages) -> {
            messages.addMessage(new ValidationMessage("validator2:" + s, s));
            return messages;
        };
    }

    public void testChainValidated() {
        ValidationMessages validationMessages = new ValidationMessages();
        new ValidatorChain(new Validator[]{this.validator1, this.validator2}).validate((Object)"a", validationMessages);
        ValidatorChainTest.assertNotNull((Object)validationMessages.getFor("validator1:a"));
        ValidatorChainTest.assertEquals((int)1, (int)validationMessages.getFor("validator1:a").size());
        ValidatorChainTest.assertNotNull((Object)validationMessages.getFor("validator2:a"));
        ValidatorChainTest.assertEquals((int)1, (int)validationMessages.getFor("validator2:a").size());
    }

    public void testChainValidatedAndThrown() {
        try {
            ValidatorChain.validateAndThrowIfNotEmpty((Object)"a", (Validator[])new Validator[]{this.validator1, this.validator2});
        }
        catch (ValidationException e) {
            ValidatorChainTest.assertNotNull((Object)e.getMessages().getFor("validator1:a"));
            ValidatorChainTest.assertEquals((int)1, (int)e.getMessages().getFor("validator1:a").size());
            ValidatorChainTest.assertNotNull((Object)e.getMessages().getFor("validator2:a"));
            ValidatorChainTest.assertEquals((int)1, (int)e.getMessages().getFor("validator2:a").size());
        }
    }
}

