/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.validation;

import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class ValidationMessagesTest
extends TestCase {
    private ValidationMessages validationMessages;

    public void setUp() {
        this.validationMessages = new ValidationMessages();
        this.validationMessages.addMessage(new ValidationMessage("a", "a1"));
        this.validationMessages.addMessage(new ValidationMessage("a", "a2"));
        this.validationMessages.addMessage(new ValidationMessage("b", "b1"));
        this.validationMessages.addMessage(new ValidationMessage("b", "b2"));
    }

    public void testSizeIsCorrect() {
        ValidationMessagesTest.assertEquals((int)4, (int)this.validationMessages.size());
    }

    public void testCanRetrieveById() {
        ValidationMessagesTest.assertNotNull((Object)this.validationMessages.getFor("a"));
    }

    public void testCanSetMessages() {
        this.validationMessages.setMessages((List)new LinkedList<ValidationMessage>(){
            {
                this.add(new ValidationMessage("b", "b2"));
                this.add(new ValidationMessage("b", "b1"));
                this.add(new ValidationMessage("a", "a2"));
                this.add(new ValidationMessage("a", "a1"));
            }
        });
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        for (ValidationMessage validationMessage : this.validationMessages) {
            messages.add(validationMessage);
        }
        ValidationMessagesTest.assertEquals((String)"b2", (String)((ValidationMessage)messages.get(0)).getMessage());
        ValidationMessagesTest.assertEquals((String)"b1", (String)((ValidationMessage)messages.get(1)).getMessage());
        ValidationMessagesTest.assertEquals((String)"a2", (String)((ValidationMessage)messages.get(2)).getMessage());
        ValidationMessagesTest.assertEquals((String)"a1", (String)((ValidationMessage)messages.get(3)).getMessage());
    }

    public void testIdCollisions() {
        ValidationMessagesTest.assertNotNull((Object)this.validationMessages.getFor("a"));
        ValidationMessagesTest.assertEquals((int)2, (int)this.validationMessages.getFor("a").size());
        ValidationMessagesTest.assertEquals((String)"a1", (String)((ValidationMessage)this.validationMessages.getFor("a").get(0)).getMessage());
        ValidationMessagesTest.assertEquals((String)"a2", (String)((ValidationMessage)this.validationMessages.getFor("a").get(1)).getMessage());
        ValidationMessagesTest.assertNotNull((Object)this.validationMessages.getFor("b"));
        ValidationMessagesTest.assertEquals((int)2, (int)this.validationMessages.getFor("b").size());
        ValidationMessagesTest.assertEquals((String)"b1", (String)((ValidationMessage)this.validationMessages.getFor("b").get(0)).getMessage());
        ValidationMessagesTest.assertEquals((String)"b2", (String)((ValidationMessage)this.validationMessages.getFor("b").get(1)).getMessage());
    }

    public void testAddOrderPreserved() {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        for (ValidationMessage validationMessage : this.validationMessages) {
            messages.add(validationMessage);
        }
        ValidationMessagesTest.assertEquals((String)"a1", (String)((ValidationMessage)messages.get(0)).getMessage());
        ValidationMessagesTest.assertEquals((String)"a2", (String)((ValidationMessage)messages.get(1)).getMessage());
        ValidationMessagesTest.assertEquals((String)"b1", (String)((ValidationMessage)messages.get(2)).getMessage());
        ValidationMessagesTest.assertEquals((String)"b2", (String)((ValidationMessage)messages.get(3)).getMessage());
    }
}

