/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.SimpleRepositoryDetails;
import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.ServerFieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.SvnRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.SvnSymbolicRules;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.SvnRepositoryClientValidator;
import java.util.Collections;

public class SvnRepositoryClientValidatorTest
extends ValidationTestBase {
    private SvnRepositoryDetails update;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.update = new SvnRepositoryDetails("", "", "http://google.com", "", "", "", true, new SvnRepositoryDetails.AdvancedOptions(true, Integer.valueOf(1), "1 minute", Float.valueOf(1.0f), "utf-8", null, Long.valueOf(0L), true, false, false, new SvnSymbolicRules(Collections.emptyList(), Collections.emptyList(), Collections.emptyList())));
    }

    public void testAllGood() {
        this.validate();
        SvnRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNotOneOfOurs() {
        new SvnRepositoryClientValidator(ServerFieldValidationConstants.newInstance()).validate((RepositoryDetails)new SimpleRepositoryDetails(), this.validationMessages);
        SvnRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNoAdvancedOptions() {
        this.update.setAdvancedOptions(null);
        this.validate();
        SvnRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testEmptyURL() {
        this.update.setUrl(null);
        this.validate();
        SvnRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        SvnRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("svn.url"));
    }

    public void testNegativeBlockSize() {
        this.update.getAdvancedOptions().setBlockSize(Integer.valueOf(-1));
        this.validate();
        SvnRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        SvnRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("svn.blocksize"));
    }

    public void testNegativeThrottle() {
        this.update.getAdvancedOptions().setThrottle(Float.valueOf(-1.0f));
        this.validate();
        SvnRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        SvnRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("svn.throttle"));
    }

    public void testNegativeStartRevision() {
        this.update.getAdvancedOptions().setStartRevision(Long.valueOf(-1L));
        this.validate();
        SvnRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        SvnRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("svn.startrevision"));
    }

    private void validate() {
        new SvnRepositoryClientValidator(ServerFieldValidationConstants.newInstance()).validate((RepositoryDetails)this.update, this.validationMessages);
    }
}

