/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.SimpleRepositoryDetails;
import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.ServerFieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.repositories.PerforceRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.PerforceRepositoryClientValidator;

public class PerforceRepositoryClientValidatorTest
extends ValidationTestBase {
    private PerforceRepositoryDetails update;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.update = new PerforceRepositoryDetails("", "", "host", Integer.valueOf(8080), "path", null, null, true, new PerforceRepositoryDetails.AdvancedOptions(true, Integer.valueOf(1), Integer.valueOf(1), null, Float.valueOf(1.0f), "utf-8", true, true, true, true, Long.valueOf(0L), true));
    }

    public void testAllGood() {
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNotOneOfOurs() {
        new PerforceRepositoryClientValidator(ServerFieldValidationConstants.newInstance()).validate((RepositoryDetails)new SimpleRepositoryDetails(), this.validationMessages);
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNoAdvancedOptions() {
        this.update.setAdvancedOptions(null);
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testValidNullValies() {
        this.update.setPort(null);
        this.update.getAdvancedOptions().setBlockSize(null);
        this.update.getAdvancedOptions().setFilelogLimit(null);
        this.update.getAdvancedOptions().setStartRevision(null);
        this.update.getAdvancedOptions().setThrottle(null);
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNoHostOrPath() {
        this.update.setHost("");
        this.update.setPath("");
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)2, (int)this.validationMessages.size());
        PerforceRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("perforce.host"));
        PerforceRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("perforce.path"));
    }

    public void testNegativePort() {
        this.update.setPort(Integer.valueOf(-1));
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        PerforceRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("perforce.port"));
    }

    public void testNegativeBlocksize() {
        this.update.getAdvancedOptions().setBlockSize(Integer.valueOf(-1));
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        PerforceRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("perforce.blocksize"));
    }

    public void testNegativeFilelogLimt() {
        this.update.getAdvancedOptions().setFilelogLimit(Integer.valueOf(-1));
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        PerforceRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("perforce.fileloglimit"));
    }

    public void testNegativeThrottle() {
        this.update.getAdvancedOptions().setThrottle(Float.valueOf(-1.0f));
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        PerforceRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("perforce.throttle"));
    }

    public void testNegativeRevision() {
        this.update.getAdvancedOptions().setStartRevision(Long.valueOf(-1L));
        this.validate();
        PerforceRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        PerforceRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("perforce.startrevision"));
    }

    private void validate() {
        new PerforceRepositoryClientValidator(ServerFieldValidationConstants.newInstance()).validate((RepositoryDetails)this.update, this.validationMessages);
    }
}

