/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.SimpleRepositoryDetails;
import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.ServerFieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.repositories.MercurialRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.MercurialRepositoryClientValidator;

public class MercurialRepositoryClientValidatorTest
extends ValidationTestBase {
    private MercurialRepositoryDetails update;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.update = new MercurialRepositoryDetails("", "", "repoLocation", null, new MercurialRepositoryDetails.AdvancedOptions(true, Integer.valueOf(1), "1 minute"));
    }

    public void testAllGood() {
        this.validate();
        MercurialRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNotOneOfOurs() {
        new MercurialRepositoryClientValidator(ServerFieldValidationConstants.newInstance()).validate((RepositoryDetails)new SimpleRepositoryDetails(), this.validationMessages);
        MercurialRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNoAdvancedOptions() {
        this.update.setAdvancedOptions(null);
        this.validate();
        MercurialRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testEmptyRepoLocation() {
        this.update.setRepoLocation("");
        this.validate();
        MercurialRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        MercurialRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("mercurial.repolocation"));
    }

    public void testMegativeBlockSize() {
        this.update.getAdvancedOptions().setBlockSize(Integer.valueOf(-1));
        this.validate();
        MercurialRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        MercurialRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("mercurial.blocksize"));
    }

    private void validate() {
        new MercurialRepositoryClientValidator(ServerFieldValidationConstants.newInstance()).validate((RepositoryDetails)this.update, this.validationMessages);
    }
}

