/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories.validation;

import com.atlassian.fecru.gwt.admin.SimpleRepositoryDetails;
import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.ServerFieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.repositories.GitRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.GitRepositoryClientValidator;

public class GitRepositoryClientValidatorTest
extends ValidationTestBase {
    private GitRepositoryDetails update;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.update = new GitRepositoryDetails("", "", "repoLocation", "", null, new GitRepositoryDetails.AdvancedOptions(true, Integer.valueOf(1), GitRepositoryDetails.RenameDetection.COPIES, "1 hour"));
    }

    public void testAllGood() {
        this.validate();
        GitRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNotOneOfOurs() {
        new GitRepositoryClientValidator(ServerFieldValidationConstants.newInstance()).validate((RepositoryDetails)new SimpleRepositoryDetails(), this.validationMessages);
        GitRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNoAdvancedOptions() {
        this.update.setAdvancedOptions(null);
        this.validate();
        GitRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testEmptyRepoLocation() {
        this.update.setRepoLocation("");
        this.validate();
        GitRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        GitRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("git.repolocation"));
    }

    public void testMegativeBlockSize() {
        this.update.getAdvancedOptions().setBlockSize(Integer.valueOf(-1));
        this.validate();
        GitRepositoryClientValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        GitRepositoryClientValidatorTest.assertNotNull((Object)this.validationMessages.getFor("git.blocksize"));
    }

    private void validate() {
        new GitRepositoryClientValidator(ServerFieldValidationConstants.newInstance()).validate((RepositoryDetails)this.update, this.validationMessages);
    }
}

