/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.UpdateOptionsServerValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.CvsUpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.DefaultUpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.PolledUpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.UpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class UpdateOptionsServerValidatorTest
extends ValidationTestBase {
    public void testEmptyFullScanInterval() {
        CvsUpdateOptions updateOptions = new CvsUpdateOptions();
        updateOptions.setFullScanInterval("");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNullFullScanInterval() {
        CvsUpdateOptions updateOptions = new CvsUpdateOptions();
        updateOptions.setFullScanInterval(null);
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testZeroFullScanInterval() {
        CvsUpdateOptions updateOptions = new CvsUpdateOptions();
        updateOptions.setFullScanInterval("0");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testPositiveFullScanInterval() {
        CvsUpdateOptions updateOptions = new CvsUpdateOptions();
        updateOptions.setFullScanInterval("2mo");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testInvalidFullScanInterval() {
        CvsUpdateOptions updateOptions = new CvsUpdateOptions();
        updateOptions.setFullScanInterval("asdf");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
    }

    public void testEmptyPollInterval() {
        PolledUpdateOptions updateOptions = new PolledUpdateOptions();
        updateOptions.setPollInterval("");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNullPollInterval() {
        PolledUpdateOptions updateOptions = new PolledUpdateOptions();
        updateOptions.setPollInterval(null);
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNeverPollInterval() {
        PolledUpdateOptions updateOptions = new PolledUpdateOptions();
        updateOptions.setPollInterval("never");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testZeroPollInterval() {
        PolledUpdateOptions updateOptions = new PolledUpdateOptions();
        updateOptions.setPollInterval("0");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testPositivePollInterval() {
        PolledUpdateOptions updateOptions = new PolledUpdateOptions();
        updateOptions.setPollInterval("2mo");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testPositivePollIntervalWithoutUnit() {
        PolledUpdateOptions updateOptions = new PolledUpdateOptions();
        updateOptions.setPollInterval("2");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testInvalidPollInterval() {
        PolledUpdateOptions updateOptions = new PolledUpdateOptions();
        updateOptions.setPollInterval("asdf");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)updateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
    }

    public void testFullScanPeriodGreaterThanPollingPeriod() throws Exception {
        CvsUpdateOptions cvsUpdateOptions = new CvsUpdateOptions(null, "333s", null, "666s");
        new UpdateOptionsServerValidator("").validate((UpdateOptions)cvsUpdateOptions, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((int)1, (int)this.validationMessages.size());
        UpdateOptionsServerValidatorTest.assertEquals((String)"Full scan interval must be at least as large as the polling interval", (String)((ValidationMessage)this.validationMessages.getFor("fullScanInterval").get(0)).getMessage());
    }

    public void testDefaults() throws Exception {
        DefaultUpdateOptions validDefaults = new DefaultUpdateOptions(new CvsUpdateOptions(null, "10m", null, "1m"), new PolledUpdateOptions("1m"));
        new UpdateOptionsServerValidator("").validate((UpdateOptions)validDefaults, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((int)0, (int)this.validationMessages.size());
    }

    public void testDefaults_withErrors() throws Exception {
        DefaultUpdateOptions validDefaults = new DefaultUpdateOptions(new CvsUpdateOptions(null, "gaga", null, "gugu"), new PolledUpdateOptions("gogo"));
        new UpdateOptionsServerValidator("").validate((UpdateOptions)validDefaults, this.validationMessages);
        UpdateOptionsServerValidatorTest.assertEquals((int)3, (int)this.validationMessages.size());
        Assert.assertThat((Object)((ValidationMessage)this.validationMessages.getFor("cvs.fullScanInterval").get(0)).getMessage(), (Matcher)Matchers.stringContainsInOrder(Arrays.asList("Invalid interval: ", "gaga")));
        Assert.assertThat((Object)((ValidationMessage)this.validationMessages.getFor("cvs.pollInterval").get(0)).getMessage(), (Matcher)Matchers.stringContainsInOrder(Arrays.asList("Invalid interval: ", "gugu")));
        Assert.assertThat((Object)((ValidationMessage)this.validationMessages.getFor("polled.pollInterval").get(0)).getMessage(), (Matcher)Matchers.stringContainsInOrder(Arrays.asList("Invalid interval: ", "gogo")));
    }
}

