/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.ServerValidationUtils;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import java.nio.charset.Charset;

public class ServerValidationUtilsTest
extends ValidationTestBase {
    public void testNullOpTimeoutValidation() {
        ServerValidationUtils.validateOpTimeout(null, (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)0, (int)this.validationMessages.size());
    }

    public void testCorrectOpTimeoutValidation() {
        ServerValidationUtils.validateOpTimeout((String)"9 seconds", (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtils.validateOpTimeout((String)"12 days", (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtils.validateOpTimeout((String)"7 mi", (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)0, (int)this.validationMessages.size());
    }

    public void testInvalidOpTimeoutValidation() {
        ServerValidationUtils.validateOpTimeout((String)"foo", (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtils.validateOpTimeout((String)"bar", (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtils.validateOpTimeout((String)"123", (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtils.validateOpTimeout((String)"", (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)4, (int)this.validationMessages.size());
    }

    public void testNullCharsetValidation() {
        ServerValidationUtils.validateCharset(null, (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)0, (int)this.validationMessages.size());
    }

    public void testExistingCharsetValidation() {
        ServerValidationUtils.validateCharset((String)Charset.availableCharsets().keySet().iterator().next(), (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)0, (int)this.validationMessages.size());
    }

    public void testNonExistantCharsetValidation() {
        ServerValidationUtils.validateCharset((String)"foo", (String)"someId", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)1, (int)this.validationMessages.size());
        ServerValidationUtilsTest.assertEquals((String)"someId", (String)((ValidationMessage)this.validationMessages.getMessages().get(0)).getTargetId());
    }

    public void testValidateGlob() {
        String messageIfNullOrEmpty = "message if null or empty";
        ServerValidationUtils.validateGlob((String)"test", (String)"1", (String)"message if null or empty", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)0, (int)this.validationMessages.size());
        ServerValidationUtils.validateGlob((String)"/exclude/**/this", (String)"2", (String)"message if null or empty", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)0, (int)this.validationMessages.size());
        ServerValidationUtils.validateGlob(null, (String)"3", (String)"message if null or empty", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)1, (int)this.validationMessages.size());
        ServerValidationUtilsTest.assertEquals((String)"message if null or empty", (String)((ValidationMessage)this.validationMessages.iterator().next()).getMessage());
        this.validationMessages = new ValidationMessages();
        ServerValidationUtils.validateGlob((String)"", (String)"4", (String)"message if null or empty", (ValidationMessages)this.validationMessages);
        ServerValidationUtilsTest.assertEquals((int)1, (int)this.validationMessages.size());
        ServerValidationUtilsTest.assertEquals((String)"message if null or empty", (String)((ValidationMessage)this.validationMessages.iterator().next()).getMessage());
    }
}

