/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.SimpleRepositoryDetails;
import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.AddRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;
import org.mockito.Mockito;

public class AddRepositoryServerValidatorTest
extends ValidationTestBase {
    public RepositoryDetails update;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.update = new SimpleRepositoryDetails(null, "repo", "");
    }

    public void testAllGood() {
        this.validate();
        AddRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testRepoAlreadyExists() {
        this.update.setName("existingrepo");
        this.validate();
        AddRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        AddRepositoryServerValidatorTest.assertNotNull((Object)this.validationMessages.getFor("name"));
    }

    public void testRepoWithInvalidName() {
        this.update.setName("   abc   ");
        this.validate();
        AddRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        AddRepositoryServerValidatorTest.assertNotNull((Object)this.validationMessages.getFor("name"));
    }

    private void validate() {
        RepositoryAdminService mockService = (RepositoryAdminService)Mockito.mock(RepositoryAdminService.class);
        Mockito.when((Object)mockService.exists("existingrepo")).thenReturn((Object)true);
        new AddRepositoryServerValidator(mockService).validate(this.update, this.validationMessages);
    }
}

