/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.SimpleRepositoryDetails;
import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.MercurialRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.MercurialRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.security.MockSshKeyManager;
import com.atlassian.fecru.security.SshKeyManager;

public class AddMercurialRepositoryServerValidatorTest
extends ValidationTestBase {
    public MercurialRepositoryDetails update;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.update = new MercurialRepositoryDetails("repo", "", "repoLocation", null, new MercurialRepositoryDetails.AdvancedOptions(true, Integer.valueOf(1), "1 minute"));
    }

    public void testAllGood() {
        this.validate();
        AddMercurialRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNotOneOfOurs() {
        new MercurialRepositoryServerValidator((SshKeyManager)new MockSshKeyManager()).validate((RepositoryDetails)new SimpleRepositoryDetails(), this.validationMessages);
        AddMercurialRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testNoAdvancedOptions() {
        this.update.setAdvancedOptions(null);
        this.validate();
        AddMercurialRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testInvalidOpTimeout() throws Exception {
        this.update.getAdvancedOptions().setOpTimeout("foo");
        this.validate();
        AddMercurialRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
        AddMercurialRepositoryServerValidatorTest.assertNotNull((Object)this.validationMessages.getFor("mercurial.optimeout"));
    }

    public void testNullOpTimeout() throws Exception {
        this.update.getAdvancedOptions().setOpTimeout(null);
        this.validate();
        AddMercurialRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    public void testEmptyOpTimeout() throws Exception {
        this.update.getAdvancedOptions().setOpTimeout("");
        this.validate();
        AddMercurialRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
    }

    private void validate() {
        new MercurialRepositoryServerValidator((SshKeyManager)new MockSshKeyManager()).validate((RepositoryDetails)this.update, this.validationMessages);
    }
}

