/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.ValidationTestBase;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.CvsRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.CvsRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class AddCvsRepositoryServerValidatorTest
extends ValidationTestBase {
    private CvsRepositoryDetails update;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.update = new CvsRepositoryDetails("", "", null, new CvsRepositoryDetails.AdvancedOptions("utf-8"));
    }

    public void testAllGood() throws IOException {
        File tempDir = File.createTempFile(this.getName(), "dir");
        try {
            tempDir.delete();
            tempDir.mkdir();
            this.update.setDir(tempDir.getAbsolutePath());
            this.validate();
            AddCvsRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)0, (int)this.validationMessages.size());
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
    }

    public void testCvsDirIsAFile() throws IOException {
        File tempDir = File.createTempFile(this.getName(), "notadir");
        try {
            this.update.setDir(tempDir.getAbsolutePath());
            this.validate();
            AddCvsRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
            AddCvsRepositoryServerValidatorTest.assertNotNull((Object)this.validationMessages.getFor("cvs.dir"));
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
    }

    public void testCvsDirDoesntExist() throws IOException {
        File tempDir = File.createTempFile(this.getName(), "dir");
        try {
            tempDir.delete();
            this.update.setDir(tempDir.getAbsolutePath());
            this.validate();
            AddCvsRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
            AddCvsRepositoryServerValidatorTest.assertNotNull((Object)this.validationMessages.getFor("cvs.dir"));
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
    }

    public void testInvalidCvsCharset() throws IOException {
        File tempDir = File.createTempFile(this.getName(), "dir");
        try {
            tempDir.delete();
            tempDir.mkdir();
            this.update.setDir(tempDir.getAbsolutePath());
            this.update.getAdvancedOptions().setCharset("foobar");
            this.validate();
            AddCvsRepositoryServerValidatorTest.assertEquals((String)this.validationMessages.toString(), (int)1, (int)this.validationMessages.size());
            AddCvsRepositoryServerValidatorTest.assertNotNull((Object)this.validationMessages.getFor("cvs.charset"));
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
    }

    private void validate() {
        new CvsRepositoryServerValidator().validate((RepositoryDetails)this.update, this.validationMessages);
    }
}

