/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories;

import com.atlassian.fecru.gwt.admin.server.repositories.PerforceRepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.shared.repositories.PerforceRepositoryDetails;
import com.atlassian.fisheye.spi.admin.data.P4RepositoryData;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PerforceRepositoryDetailsServerBuilderTest {
    private PerforceRepositoryDetailsServerBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = new PerforceRepositoryDetailsServerBuilder();
    }

    @Test
    public void testToClientType_defaultValues() throws Exception {
        P4RepositoryData p4RepositoryData = new P4RepositoryData("repo_name", "server1.com", "//depot/fecru/");
        PerforceRepositoryDetails actual = this.builder.toClientType(p4RepositoryData);
        Assert.assertEquals((Object)"repo_name", (Object)actual.getName());
        Assert.assertEquals((Object)"server1.com", (Object)actual.getHost());
        Assert.assertEquals((Object)"//depot/fecru/", (Object)actual.getPath());
        Assert.assertNull((Object)actual.getUsername());
        Assert.assertNull((Object)actual.getPassword());
        Assert.assertFalse((boolean)actual.getWasPasswordInitiallySet());
        Assert.assertNull((Object)actual.getAdvancedOptions().getBlockSize());
        Assert.assertTrue((boolean)actual.getAdvancedOptions().isCaseSensitive());
        Assert.assertFalse((boolean)actual.getAdvancedOptions().isDisableMultiPrint());
        Assert.assertNull((Object)actual.getAdvancedOptions().getCharset());
        Assert.assertNull((Object)actual.getAdvancedOptions().getOpTimeout());
        Assert.assertNull((Object)actual.getAdvancedOptions().getThrottle());
        Assert.assertNull((Object)actual.getAdvancedOptions().getFilelogLimit());
        Assert.assertFalse((boolean)actual.getAdvancedOptions().isInitialImport());
        Assert.assertNull((Object)actual.getPort());
        Assert.assertFalse((boolean)actual.getAdvancedOptions().isSkipLabels());
        Assert.assertNull((Object)actual.getAdvancedOptions().getStartRevision());
        Assert.assertFalse((boolean)actual.getAdvancedOptions().isUnicode());
    }

    @Test
    public void testToClientType_customValues() throws Exception {
        P4RepositoryData p4RepositoryData = new P4RepositoryData("repo_name", "server1.com", "//depot/fecru/");
        p4RepositoryData.setUsername("user1");
        p4RepositoryData.setPassword("pass1");
        p4RepositoryData.setBlockSize(Integer.valueOf(42));
        p4RepositoryData.setCaseSensitive(Boolean.valueOf(false));
        p4RepositoryData.setDisableMutli(Boolean.valueOf(true));
        p4RepositoryData.setCharset(Charset.forName("UTF-16"));
        p4RepositoryData.setCommandTimeout("42s");
        p4RepositoryData.setConnectionsPerSecond(Float.valueOf(3.0f));
        p4RepositoryData.setFileLogLimit(Integer.valueOf(14));
        p4RepositoryData.setInitialImport(Boolean.valueOf(true));
        p4RepositoryData.setPort(Integer.valueOf(1606));
        p4RepositoryData.setSkipLabels(Boolean.valueOf(true));
        p4RepositoryData.setStartRevision(Long.valueOf(2015L));
        p4RepositoryData.setUnicode(Boolean.valueOf(true));
        PerforceRepositoryDetails actual = this.builder.toClientType(p4RepositoryData);
        Assert.assertEquals((Object)"repo_name", (Object)actual.getName());
        Assert.assertEquals((Object)"server1.com", (Object)actual.getHost());
        Assert.assertEquals((Object)"//depot/fecru/", (Object)actual.getPath());
        Assert.assertEquals((Object)"user1", (Object)actual.getUsername());
        Assert.assertNull((Object)actual.getPassword());
        Assert.assertTrue((boolean)actual.getWasPasswordInitiallySet());
        Assert.assertEquals((long)42L, (long)actual.getAdvancedOptions().getBlockSize().intValue());
        Assert.assertFalse((boolean)actual.getAdvancedOptions().isCaseSensitive());
        Assert.assertTrue((boolean)actual.getAdvancedOptions().isDisableMultiPrint());
        Assert.assertEquals((Object)"UTF-16", (Object)actual.getAdvancedOptions().getCharset());
        Assert.assertEquals((Object)"42s", (Object)actual.getAdvancedOptions().getOpTimeout());
        Assert.assertEquals((float)3.0f, (float)actual.getAdvancedOptions().getThrottle().floatValue(), (float)0.0f);
        Assert.assertEquals((long)14L, (long)actual.getAdvancedOptions().getFilelogLimit().intValue());
        Assert.assertTrue((boolean)actual.getAdvancedOptions().isInitialImport());
        Assert.assertEquals((long)1606L, (long)actual.getPort().intValue());
        Assert.assertTrue((boolean)actual.getAdvancedOptions().isSkipLabels());
        Assert.assertEquals((long)2015L, (long)actual.getAdvancedOptions().getStartRevision());
        Assert.assertTrue((boolean)actual.getAdvancedOptions().isUnicode());
    }

    @Test
    public void testToServerType_defaultValues() throws Exception {
        PerforceRepositoryDetails details = new PerforceRepositoryDetails("repo_name", "repo description", "server1.com", null, "//depot/fecru/", null, null, false, null);
        P4RepositoryData actual = this.builder.toServerType(details);
        Assert.assertEquals((Object)"repo_name", (Object)actual.getName());
        Assert.assertEquals((Object)"repo description", (Object)actual.getDescription());
        Assert.assertEquals((Object)"server1.com", (Object)actual.getServer());
        Assert.assertNull((Object)actual.getPort());
        Assert.assertEquals((Object)"//depot/fecru/", (Object)actual.getPath());
        Assert.assertNull((Object)actual.getUsername());
        Assert.assertNull((Object)actual.getPassword());
        Assert.assertTrue((boolean)actual.isStoreDiff());
        Assert.assertNull((Object)actual.getBlockSize());
        Assert.assertNull((Object)actual.getFileLogLimit());
        Assert.assertNull((Object)actual.getCommandTimeout());
        Assert.assertNull((Object)actual.getConnectionsPerSecond());
        Assert.assertNull((Object)actual.getCharset());
        Assert.assertNull((Object)actual.isUnicode());
        Assert.assertNull((Object)actual.isSkipLabels());
        Assert.assertNull((Object)actual.isCaseSensitive());
        Assert.assertNull((Object)actual.isDisableMutli());
        Assert.assertNull((Object)actual.getStartRevision());
        Assert.assertNull((Object)actual.isInitialImport());
    }

    @Test
    public void testToServerType_nullAdvancedOptions() throws Exception {
        PerforceRepositoryDetails details = new PerforceRepositoryDetails("repo_name", "repo description", "server1.com", null, "//depot/fecru/", null, null, false, new PerforceRepositoryDetails.AdvancedOptions(true, null, null, null, null, null, true, true, true, true, null, true));
        P4RepositoryData actual = this.builder.toServerType(details);
        Assert.assertEquals((Object)"repo_name", (Object)actual.getName());
        Assert.assertEquals((Object)"repo description", (Object)actual.getDescription());
        Assert.assertEquals((Object)"server1.com", (Object)actual.getServer());
        Assert.assertNull((Object)actual.getPort());
        Assert.assertEquals((Object)"//depot/fecru/", (Object)actual.getPath());
        Assert.assertNull((Object)actual.getUsername());
        Assert.assertNull((Object)actual.getPassword());
        Assert.assertTrue((boolean)actual.isStoreDiff());
        Assert.assertNull((Object)actual.getBlockSize());
        Assert.assertNull((Object)actual.getFileLogLimit());
        Assert.assertNull((Object)actual.getCommandTimeout());
        Assert.assertNull((Object)actual.getConnectionsPerSecond());
        Assert.assertNull((Object)actual.getCharset());
        Assert.assertTrue((boolean)actual.isUnicode());
        Assert.assertTrue((boolean)actual.isSkipLabels());
        Assert.assertTrue((boolean)actual.isCaseSensitive());
        Assert.assertTrue((boolean)actual.isDisableMutli());
        Assert.assertNull((Object)actual.getStartRevision());
        Assert.assertTrue((boolean)actual.isInitialImport());
    }

    @Test
    public void testToServerType_customValues() throws Exception {
        PerforceRepositoryDetails details = new PerforceRepositoryDetails("repo_name", "repo description", "server1.com", Integer.valueOf(1606), "//depot/fecru/", "user1", "pass1", true, new PerforceRepositoryDetails.AdvancedOptions(false, Integer.valueOf(42), Integer.valueOf(14), "42s", Float.valueOf(3.0f), "UTF-16", true, true, false, true, Long.valueOf(2015L), true));
        P4RepositoryData actual = this.builder.toServerType(details);
        Assert.assertEquals((Object)"repo_name", (Object)actual.getName());
        Assert.assertEquals((Object)"repo description", (Object)actual.getDescription());
        Assert.assertEquals((Object)"server1.com", (Object)actual.getServer());
        Assert.assertEquals((long)1606L, (long)actual.getPort().intValue());
        Assert.assertEquals((Object)"//depot/fecru/", (Object)actual.getPath());
        Assert.assertEquals((Object)"user1", (Object)actual.getUsername());
        Assert.assertEquals((Object)"pass1", (Object)actual.getPassword());
        Assert.assertFalse((boolean)actual.isStoreDiff());
        Assert.assertEquals((long)42L, (long)actual.getBlockSize().intValue());
        Assert.assertEquals((long)14L, (long)actual.getFileLogLimit().intValue());
        Assert.assertEquals((Object)"42s", (Object)actual.getCommandTimeout());
        Assert.assertEquals((float)3.0f, (float)actual.getConnectionsPerSecond().floatValue(), (float)0.0f);
        Assert.assertEquals((Object)Charset.forName("UTF-16"), (Object)actual.getCharset());
        Assert.assertTrue((boolean)actual.isUnicode());
        Assert.assertTrue((boolean)actual.isSkipLabels());
        Assert.assertFalse((boolean)actual.isCaseSensitive());
        Assert.assertTrue((boolean)actual.isDisableMutli());
        Assert.assertEquals((long)2015L, (long)actual.getStartRevision());
        Assert.assertTrue((boolean)actual.isInitialImport());
    }
}

