/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server;

import com.atlassian.fecru.gwt.admin.server.AdminRequestTracker;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserTestHelper;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class AdminRequestTrackerTest {
    private UserManager userManager;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private UserLogin userLogin;

    @Before
    public void setUp() throws Exception {
        this.userManager = (UserManager)Mockito.mock(UserManager.class);
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        LoginCookie lc = LoginCookie.createRememberMeCookie((FecruUser)new FecruUser("kminoque"), (String)"random");
        lc.setLoginId(Long.valueOf(666L));
        this.userLogin = UserTestHelper.createPrincipal("Kylie");
        Mockito.when((Object)this.userManager.validateCurrentUser(this.request, this.response)).thenReturn((Object)this.userLogin);
        Mockito.when((Object)this.request.getLocale()).thenReturn((Object)Locale.getDefault());
    }

    @Test
    public void testRequestTracked() {
        MockAdminRequestTracker tracker = new MockAdminRequestTracker();
        tracker.onRequestStarted(this.request, this.response);
        Assert.assertTrue((boolean)tracker.getCurrentRequestDetails().isAdminUser());
        Assert.assertSame((Object)Locale.getDefault(), (Object)tracker.getCurrentRequestDetails().getLocale());
        Assert.assertSame((Object)this.request, (Object)tracker.getCurrentRequestDetails().getServletRequest());
        Assert.assertSame((Object)this.response, (Object)tracker.getCurrentRequestDetails().getServletResponse());
    }

    @Test
    public void testNotAdminUserIfDbException() {
        AdminRequestTracker tracker = new AdminRequestTracker(this.userManager){

            protected boolean isAdminUser(HttpServletRequest servletRequest) throws DbException {
                throw new DbException("Blurk");
            }
        };
        tracker.onRequestStarted(this.request, this.response);
        Assert.assertFalse((boolean)tracker.getCurrentRequestDetails().isAdminUser());
        Assert.assertSame((Object)Locale.getDefault(), (Object)tracker.getCurrentRequestDetails().getLocale());
        Assert.assertSame((Object)this.request, (Object)tracker.getCurrentRequestDetails().getServletRequest());
        Assert.assertSame((Object)this.response, (Object)tracker.getCurrentRequestDetails().getServletResponse());
    }

    @Test
    public void testRequestCleared() {
        MockAdminRequestTracker tracker = new MockAdminRequestTracker();
        tracker.onRequestStarted(this.request, this.response);
        tracker.onRequestEnded(this.request, this.response);
        Assert.assertNull((Object)tracker.getCurrentRequestDetails());
    }

    private class MockAdminRequestTracker
    extends AdminRequestTracker {
        public MockAdminRequestTracker() {
            super(AdminRequestTrackerTest.this.userManager);
        }

        protected boolean isAdminUser(HttpServletRequest servletRequest) throws DbException {
            return true;
        }
    }
}

