/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.client.ui.repositories;

import com.atlassian.fecru.gwt.GwtRepositoryTestHelpers;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.AddRepositoryPresenter;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.BaseRepositoryPresenter;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.PerforceRepositoryDetailsClientBuilder;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.ScmSettingsTabPresenter;
import com.atlassian.fecru.gwt.admin.shared.repositories.PerforceRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.FieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PerforceRepositoryDetailsClientBuilderTest {
    private GwtRepositoryTestHelpers.Display display;
    private ValidationMessages validationMessages;

    @Before
    public void setUp() throws Exception {
        this.display = GwtRepositoryTestHelpers.getMockAddRepositoryPresenterDisplay();
        this.validationMessages = new ValidationMessages();
    }

    @Test
    public void testForUpdatesShouldAlwaysAddAdvancedSettings() throws Exception {
        PerforceRepositoryDetailsClientBuilder.ForUpdates forAdditions = new PerforceRepositoryDetailsClientBuilder.ForUpdates("repo_name", (ScmSettingsTabPresenter.Display)this.display, (FieldValidationConstants)Mockito.mock(FieldValidationConstants.class), this.validationMessages);
        this.display.getAdvanced().setValue((Object)true);
        Assert.assertTrue((boolean)forAdditions.shouldAddAdvancedSettings());
        this.display.getAdvanced().setValue((Object)false);
        Assert.assertTrue((boolean)forAdditions.shouldAddAdvancedSettings());
        Assert.assertEquals((Object)"repo_name", (Object)forAdditions.getRepositoryName());
    }

    @Test
    public void testForAdditionShouldAddAdvancedSettingsAccordingToDisplay() throws Exception {
        PerforceRepositoryDetailsClientBuilder.ForAdditions forAdditions = new PerforceRepositoryDetailsClientBuilder.ForAdditions((AddRepositoryPresenter.Display)this.display, (FieldValidationConstants)Mockito.mock(FieldValidationConstants.class), this.validationMessages);
        this.display.getAdvanced().setValue((Object)true);
        Assert.assertTrue((boolean)forAdditions.shouldAddAdvancedSettings());
        this.display.getAdvanced().setValue((Object)false);
        Assert.assertFalse((boolean)forAdditions.shouldAddAdvancedSettings());
        this.display.getName().setValue((Object)"repo_name");
        Assert.assertEquals((Object)"repo_name", (Object)forAdditions.getRepositoryName());
    }

    @Test
    public void testBuildWithDefaults() throws Exception {
        PerforceRepositoryDetailsClientBuilder.ForAdditions forAdditions = new PerforceRepositoryDetailsClientBuilder.ForAdditions((AddRepositoryPresenter.Display)this.display, (FieldValidationConstants)Mockito.mock(FieldValidationConstants.class), this.validationMessages);
        PerforceRepositoryDetails repositoryDetails = (PerforceRepositoryDetails)forAdditions.build();
        Assert.assertNull((Object)repositoryDetails.getName());
        Assert.assertEquals((Object)"", (Object)repositoryDetails.getDescription());
        Assert.assertNull((Object)repositoryDetails.getHost());
        Assert.assertNull((Object)repositoryDetails.getPort());
        Assert.assertNull((Object)repositoryDetails.getPath());
        Assert.assertNull((Object)repositoryDetails.getUsername());
        Assert.assertNull((Object)repositoryDetails.getPassword());
        Assert.assertFalse((boolean)repositoryDetails.getShouldUpdatePassword());
        Assert.assertFalse((boolean)repositoryDetails.getWasPasswordInitiallySet());
        Assert.assertNull((Object)repositoryDetails.getAdvancedOptions());
    }

    @Test
    public void testBuildWithCustomValuesWithoutAdvancedOptions() throws Exception {
        PerforceRepositoryDetailsClientBuilder.ForAdditions forAdditions = new PerforceRepositoryDetailsClientBuilder.ForAdditions((AddRepositoryPresenter.Display)this.display, (FieldValidationConstants)Mockito.mock(FieldValidationConstants.class), this.validationMessages);
        BaseRepositoryPresenter.Displays.PerforceSettings perforceSettings = this.display.getPerforceSettings();
        this.display.getAdvanced().setValue((Object)false);
        this.display.getName().setValue((Object)"repo_name");
        this.display.getDescription().setValue((Object)"description");
        perforceSettings.getHost().setValue((Object)"server1.com");
        perforceSettings.getPort().setValue((Object)"1606");
        perforceSettings.getPath().setValue((Object)"//depot/fecru/");
        perforceSettings.getUsername().setValue((Object)"user1");
        perforceSettings.getPassword().setValue((Object)"pass1");
        perforceSettings.getShouldUpdatePassword().setValue((Object)true);
        PerforceRepositoryDetails repositoryDetails = (PerforceRepositoryDetails)forAdditions.build();
        Assert.assertEquals((Object)"repo_name", (Object)repositoryDetails.getName());
        Assert.assertEquals((Object)"description", (Object)repositoryDetails.getDescription());
        Assert.assertEquals((Object)"server1.com", (Object)repositoryDetails.getHost());
        Assert.assertEquals((long)1606L, (long)repositoryDetails.getPort().intValue());
        Assert.assertEquals((Object)"//depot/fecru/", (Object)repositoryDetails.getPath());
        Assert.assertEquals((Object)"user1", (Object)repositoryDetails.getUsername());
        Assert.assertEquals((Object)"pass1", (Object)repositoryDetails.getPassword());
        Assert.assertTrue((boolean)repositoryDetails.getShouldUpdatePassword());
        Assert.assertTrue((boolean)repositoryDetails.getWasPasswordInitiallySet());
        Assert.assertNull((Object)repositoryDetails.getAdvancedOptions());
    }

    @Test
    public void testBuildWithDefaultsWithAdvancedOptions() throws Exception {
        PerforceRepositoryDetailsClientBuilder.ForAdditions forAdditions = new PerforceRepositoryDetailsClientBuilder.ForAdditions((AddRepositoryPresenter.Display)this.display, (FieldValidationConstants)Mockito.mock(FieldValidationConstants.class), this.validationMessages);
        this.display.getAdvanced().setValue((Object)true);
        BaseRepositoryPresenter.Displays.PerforceSettings perforceSettings = this.display.getPerforceSettings();
        perforceSettings.getCharset().addItem((Object)"-default-");
        perforceSettings.getUnicode().setValue((Object)false);
        perforceSettings.getSkipLabels().setValue((Object)false);
        perforceSettings.getCaseSensitive().setValue((Object)false);
        perforceSettings.getDisableMultiPrint().setValue((Object)false);
        perforceSettings.getInitialImport().setValue((Object)false);
        PerforceRepositoryDetails repositoryDetails = (PerforceRepositoryDetails)forAdditions.build();
        PerforceRepositoryDetails.AdvancedOptions advancedOptions = repositoryDetails.getAdvancedOptions();
        Assert.assertFalse((boolean)advancedOptions.isStoreDiffInfo());
        Assert.assertNull((Object)advancedOptions.getBlockSize());
        Assert.assertNull((Object)advancedOptions.getFilelogLimit());
        Assert.assertNull((Object)advancedOptions.getOpTimeout());
        Assert.assertNull((Object)advancedOptions.getThrottle());
        Assert.assertNull((Object)advancedOptions.getCharset());
        Assert.assertFalse((boolean)advancedOptions.isUnicode());
        Assert.assertFalse((boolean)advancedOptions.isSkipLabels());
        Assert.assertFalse((boolean)advancedOptions.isCaseSensitive());
        Assert.assertFalse((boolean)advancedOptions.isDisableMultiPrint());
        Assert.assertNull((Object)advancedOptions.getStartRevision());
        Assert.assertFalse((boolean)advancedOptions.isInitialImport());
    }

    @Test
    public void testBuildWithCustomValueswithAdvancedOptions() throws Exception {
        PerforceRepositoryDetailsClientBuilder.ForAdditions forAdditions = new PerforceRepositoryDetailsClientBuilder.ForAdditions((AddRepositoryPresenter.Display)this.display, (FieldValidationConstants)Mockito.mock(FieldValidationConstants.class), this.validationMessages);
        BaseRepositoryPresenter.Displays.PerforceSettings perforceSettings = this.display.getPerforceSettings();
        this.display.getAdvanced().setValue((Object)true);
        this.display.getName().setValue((Object)"repo_name");
        this.display.getDescription().setValue((Object)"description");
        perforceSettings.getHost().setValue((Object)"server1.com");
        perforceSettings.getPort().setValue((Object)"1606");
        perforceSettings.getPath().setValue((Object)"//depot/fecru/");
        perforceSettings.getUsername().setValue((Object)"user1");
        perforceSettings.getPassword().setValue((Object)"pass1");
        perforceSettings.getShouldUpdatePassword().setValue((Object)true);
        this.display.getStoreDiffInfo().setValue((Object)true);
        perforceSettings.getBlockSize().setValue((Object)"42");
        perforceSettings.getFilelogLimit().setValue((Object)"14");
        perforceSettings.getOpTimeout().setValue((Object)"42s");
        perforceSettings.getThrottle().setValue((Object)"3");
        perforceSettings.getCharset().addItem((Object)"UTF-42");
        perforceSettings.getCharset().addItem((Object)"UTF-16");
        perforceSettings.getCharset().setSelectedIndex(1);
        perforceSettings.getUnicode().setValue((Object)true);
        perforceSettings.getSkipLabels().setValue((Object)true);
        perforceSettings.getCaseSensitive().setValue((Object)true);
        perforceSettings.getDisableMultiPrint().setValue((Object)true);
        perforceSettings.getStartRevision().setValue((Object)"2015");
        perforceSettings.getInitialImport().setValue((Object)true);
        PerforceRepositoryDetails repositoryDetails = (PerforceRepositoryDetails)forAdditions.build();
        PerforceRepositoryDetails.AdvancedOptions advancedOptions = repositoryDetails.getAdvancedOptions();
        Assert.assertEquals((Object)"repo_name", (Object)repositoryDetails.getName());
        Assert.assertEquals((Object)"description", (Object)repositoryDetails.getDescription());
        Assert.assertEquals((Object)"server1.com", (Object)repositoryDetails.getHost());
        Assert.assertEquals((long)1606L, (long)repositoryDetails.getPort().intValue());
        Assert.assertEquals((Object)"//depot/fecru/", (Object)repositoryDetails.getPath());
        Assert.assertEquals((Object)"user1", (Object)repositoryDetails.getUsername());
        Assert.assertEquals((Object)"pass1", (Object)repositoryDetails.getPassword());
        Assert.assertTrue((boolean)repositoryDetails.getShouldUpdatePassword());
        Assert.assertTrue((boolean)repositoryDetails.getWasPasswordInitiallySet());
        Assert.assertTrue((boolean)advancedOptions.isStoreDiffInfo());
        Assert.assertEquals((long)42L, (long)advancedOptions.getBlockSize().intValue());
        Assert.assertEquals((long)14L, (long)advancedOptions.getFilelogLimit().intValue());
        Assert.assertEquals((Object)"42s", (Object)advancedOptions.getOpTimeout());
        Assert.assertEquals((float)3.0f, (float)advancedOptions.getThrottle().floatValue(), (float)0.0f);
        Assert.assertEquals((Object)"UTF-16", (Object)advancedOptions.getCharset());
        Assert.assertTrue((boolean)advancedOptions.isUnicode());
        Assert.assertTrue((boolean)advancedOptions.isSkipLabels());
        Assert.assertTrue((boolean)advancedOptions.isCaseSensitive());
        Assert.assertTrue((boolean)advancedOptions.isDisableMultiPrint());
        Assert.assertEquals((long)2015L, (long)advancedOptions.getStartRevision());
        Assert.assertTrue((boolean)advancedOptions.isInitialImport());
    }
}

