/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.client.ui.repositories;

import com.atlassian.fecru.gwt.GwtRepositoryTestHelpers;
import com.atlassian.fecru.gwt.admin.client.RepositoryAdminRpcServiceAsync;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.AddRepositoryPresenter;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.events.RepositoriesAdminEventBus;
import com.atlassian.fecru.gwt.admin.shared.repositories.CheckoutURLAttributes;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryCharsets;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryInitData;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class AddRepositoryPresenterTest {
    private AddRepositoryPresenter.Display display;
    private AddRepositoryPresenter p;

    @Before
    public void setUp() {
        this.display = GwtRepositoryTestHelpers.getMockAddRepositoryPresenterDisplay();
        RepositoryAdminRpcServiceAsync service = (RepositoryAdminRpcServiceAsync)Mockito.mock(RepositoryAdminRpcServiceAsync.class);
        RepositoriesAdminEventBus bus = (RepositoriesAdminEventBus)Mockito.mock(RepositoriesAdminEventBus.class);
        RepositoryInitData data = new RepositoryInitData(new RepositoryCharsets(Collections.singletonList("UTF-8"), "UTF-8", "UTF-8", "UTF-8"), true);
        this.p = new AddRepositoryPresenter(service, bus, this.display, data, true);
        this.p.present();
    }

    @Test
    public void testCheckoutURLCheckboxes() {
        this.display.getUseDefaultShowCheckoutURLsSetting().setValue((Object)true);
        this.display.getShowCheckoutURLs().setValue((Object)true);
        Assert.assertEquals(null, (Object)this.p.checkoutURLsPresenter.getEditedShowCheckoutURLs());
        this.display.getUseDefaultShowCheckoutURLsSetting().setValue((Object)false);
        this.display.getShowCheckoutURLs().setValue((Object)true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.p.checkoutURLsPresenter.getEditedShowCheckoutURLs());
        this.display.getUseDefaultShowCheckoutURLsSetting().setValue((Object)false);
        this.display.getShowCheckoutURLs().setValue((Object)false);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.p.checkoutURLsPresenter.getEditedShowCheckoutURLs());
        this.display.getUseDefaultShowCheckoutURLsSetting().setValue((Object)true);
        this.display.getShowCheckoutURLs().setValue((Object)false);
        Assert.assertEquals(null, (Object)this.p.checkoutURLsPresenter.getEditedShowCheckoutURLs());
    }

    @Test
    public void testCheckoutURLValues() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("foo", "bar");
        this.display.getCheckoutURL().setValue((Object)new CheckoutURLAttributes(attrs));
        Assert.assertEquals((Object)new CheckoutURLAttributes(attrs), (Object)this.p.checkoutURLsPresenter.getEditedCheckoutURL());
    }
}

