/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.client.ui.globalsettings.frontpage;

import com.atlassian.fecru.gwt.GwtTestUtils;
import com.atlassian.fecru.gwt.admin.client.GlobalSettingsAdminRpcServiceAsync;
import com.atlassian.fecru.gwt.admin.client.ui.globalsettings.frontpage.FrontPageAdminPresenter;
import com.atlassian.fecru.gwt.admin.client.ui.globalsettings.frontpage.events.FrontPageAdminEventBus;
import com.atlassian.fecru.gwt.admin.shared.globalsettings.frontpage.FrontPageMessages;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class FrontPageAdminPresenterTest
extends TestCase {
    private GlobalSettingsAdminRpcServiceAsync service;
    private FrontPageAdminEventBus eventBus;
    private FrontPageAdminPresenter.Display display;
    private HasText welcomeMessageTextEdit;
    private HasText supportMessageTextEdit;
    private HasValue<Boolean> defaultWelcomeMessageRadio;
    private HasValue<Boolean> customWelcomeMessageRadio;
    private HasValue<Boolean> defaultSupportMessageRadio;
    private HasValue<Boolean> customSupportMessageRadio;
    private GwtTestUtils.MockHasClickHandlers saveMessages;
    private GwtTestUtils.MockHasClickHandlers revertMessages;
    private boolean customWelcomeMessageEnabled = false;
    private boolean customSupportMessageEnabled = false;
    private boolean restEnabled = false;

    protected void setUp() throws Exception {
        this.service = (GlobalSettingsAdminRpcServiceAsync)Mockito.mock(GlobalSettingsAdminRpcServiceAsync.class);
        this.eventBus = new FrontPageAdminEventBus((Object)this);
        this.display = (FrontPageAdminPresenter.Display)Mockito.mock(FrontPageAdminPresenter.Display.class);
        this.welcomeMessageTextEdit = new GwtTestUtils.MockHasText();
        Mockito.when((Object)this.display.getWelcomeMessageTextBox()).thenReturn((Object)this.welcomeMessageTextEdit);
        this.supportMessageTextEdit = new GwtTestUtils.MockHasText();
        Mockito.when((Object)this.display.getSupportMessageTextBox()).thenReturn((Object)this.supportMessageTextEdit);
        this.defaultWelcomeMessageRadio = new GwtTestUtils.MockHasValue<Boolean>();
        Mockito.when((Object)this.display.getDefaultWelcomeMessageButton()).thenReturn(this.defaultWelcomeMessageRadio);
        this.customWelcomeMessageRadio = new GwtTestUtils.MockHasValue<Boolean>();
        Mockito.when((Object)this.display.getCustomWelcomeMessageButton()).thenReturn(this.customWelcomeMessageRadio);
        this.defaultSupportMessageRadio = new GwtTestUtils.MockHasValue<Boolean>();
        Mockito.when((Object)this.display.getDefaultSupportMessageButton()).thenReturn(this.defaultSupportMessageRadio);
        this.customSupportMessageRadio = new GwtTestUtils.MockHasValue<Boolean>();
        Mockito.when((Object)this.display.getCustomSupportMessageButton()).thenReturn(this.customSupportMessageRadio);
        this.saveMessages = new GwtTestUtils.MockHasClickHandlers();
        Mockito.when((Object)this.display.getSaveButton()).thenReturn((Object)this.saveMessages);
        this.revertMessages = new GwtTestUtils.MockHasClickHandlers();
        Mockito.when((Object)this.display.getRevertAnchor()).thenReturn((Object)this.revertMessages);
        ((FrontPageAdminPresenter.Display)Mockito.doAnswer(invocationOnMock -> {
            this.customWelcomeMessageEnabled = (Boolean)invocationOnMock.getArguments()[0];
            this.customSupportMessageEnabled = (Boolean)invocationOnMock.getArguments()[1];
            this.restEnabled = (Boolean)invocationOnMock.getArguments()[2];
            return null;
        }).when((Object)this.display)).enable(Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
    }

    public void testLoadCustomisedMessagesOnDisplay() {
        this.createAndPresent("Welcome!", "Support!");
        FrontPageAdminPresenterTest.assertEquals((String)"Welcome!", (String)this.welcomeMessageTextEdit.getText());
        FrontPageAdminPresenterTest.assertEquals((String)"Support!", (String)this.supportMessageTextEdit.getText());
        FrontPageAdminPresenterTest.assertFalse((boolean)((Boolean)this.defaultWelcomeMessageRadio.getValue()));
        FrontPageAdminPresenterTest.assertFalse((boolean)((Boolean)this.defaultSupportMessageRadio.getValue()));
        FrontPageAdminPresenterTest.assertTrue((boolean)this.customWelcomeMessageEnabled);
        FrontPageAdminPresenterTest.assertTrue((boolean)this.customSupportMessageEnabled);
        FrontPageAdminPresenterTest.assertTrue((boolean)this.restEnabled);
    }

    public void testLoadDefaultMessagesOnDisplay() {
        this.createAndPresent(null, null);
        FrontPageAdminPresenterTest.assertEquals((String)"", (String)this.welcomeMessageTextEdit.getText());
        FrontPageAdminPresenterTest.assertEquals((String)"", (String)this.supportMessageTextEdit.getText());
        FrontPageAdminPresenterTest.assertTrue((boolean)((Boolean)this.defaultWelcomeMessageRadio.getValue()));
        FrontPageAdminPresenterTest.assertTrue((boolean)((Boolean)this.defaultSupportMessageRadio.getValue()));
        FrontPageAdminPresenterTest.assertFalse((boolean)this.customWelcomeMessageEnabled);
        FrontPageAdminPresenterTest.assertFalse((boolean)this.customSupportMessageEnabled);
        FrontPageAdminPresenterTest.assertTrue((boolean)this.restEnabled);
    }

    public void testDoesSaveWelcomeMessage() {
        this.testDoesSaveMessage(FrontPageMessages.MessageKind.WELCOME, this.defaultWelcomeMessageRadio, this.customWelcomeMessageRadio, false, this.welcomeMessageTextEdit, "foobar", "foobar");
    }

    public void testDoesSaveDefaultWelcomeMessage() {
        this.testDoesSaveMessage(FrontPageMessages.MessageKind.WELCOME, this.defaultWelcomeMessageRadio, this.customWelcomeMessageRadio, true, this.welcomeMessageTextEdit, "foobar", "");
    }

    public void testDoesSaveSupportMessage() {
        this.testDoesSaveMessage(FrontPageMessages.MessageKind.SUPPORT, this.defaultSupportMessageRadio, this.customSupportMessageRadio, false, this.supportMessageTextEdit, "foobar", "foobar");
    }

    public void testDoesSaveDefaultSupportMessage() {
        this.testDoesSaveMessage(FrontPageMessages.MessageKind.SUPPORT, this.defaultSupportMessageRadio, this.customSupportMessageRadio, true, this.supportMessageTextEdit, "foobar", "");
    }

    public void testDoesRevertSupportMessage() {
        this.testDoesRevert(FrontPageMessages.MessageKind.SUPPORT, this.defaultSupportMessageRadio, this.customSupportMessageRadio, this.supportMessageTextEdit, true, "foobar");
    }

    public void testDoesRevertWelcomeMessage() {
        this.testDoesRevert(FrontPageMessages.MessageKind.WELCOME, this.defaultWelcomeMessageRadio, this.customWelcomeMessageRadio, this.supportMessageTextEdit, true, "foobar");
    }

    private void testDoesSaveMessage(FrontPageMessages.MessageKind typeOfMessageBeingChanged, HasValue<Boolean> defaultButton, HasValue<Boolean> customButton, boolean defaultValue, HasText messageField, String message, String expectedSavedMessage) {
        this.createAndPresent(null, null);
        defaultButton.setValue((Object)defaultValue, true);
        customButton.setValue((Object)(!defaultValue ? 1 : 0), true);
        messageField.setText(message);
        boolean[] saveCalled = new boolean[]{false};
        ((GlobalSettingsAdminRpcServiceAsync)Mockito.doAnswer(invocationOnMock -> {
            saveCalled[0] = true;
            if (typeOfMessageBeingChanged == FrontPageMessages.MessageKind.WELCOME) {
                FrontPageAdminPresenterTest.assertEquals((Object)expectedSavedMessage, (Object)invocationOnMock.getArguments()[0]);
            } else {
                FrontPageAdminPresenterTest.assertEquals((Object)expectedSavedMessage, (Object)invocationOnMock.getArguments()[1]);
            }
            ((AsyncCallback)invocationOnMock.getArguments()[2]).onSuccess(null);
            return null;
        }).when((Object)this.service)).setMessages(Mockito.anyString(), Mockito.anyString(), (AsyncCallback)Matchers.anyObject());
        this.saveMessages.click();
    }

    private void testDoesRevert(FrontPageMessages.MessageKind messageKind, HasValue<Boolean> defaultButton, HasValue<Boolean> customButton, HasText messageField, boolean defaultValue, String message) {
        this.createAndPresent(null, null);
        defaultButton.setValue((Object)defaultValue);
        customButton.setValue((Object)(!defaultValue ? 1 : 0));
        messageField.setText(message);
        boolean[] loadCalled = new boolean[]{false};
        ((GlobalSettingsAdminRpcServiceAsync)Mockito.doAnswer(invocationOnMock -> {
            loadCalled[0] = true;
            ((AsyncCallback)invocationOnMock.getArguments()[0]).onSuccess((Object)new FrontPageMessages(null, null));
            return null;
        }).when((Object)this.service)).getFrontPageMessages((AsyncCallback)Matchers.anyObject());
        this.revertMessages.click();
        FrontPageAdminPresenterTest.assertTrue((boolean)((Boolean)this.defaultWelcomeMessageRadio.getValue()));
        FrontPageAdminPresenterTest.assertFalse((boolean)this.customWelcomeMessageEnabled);
        FrontPageAdminPresenterTest.assertTrue((boolean)((Boolean)this.defaultSupportMessageRadio.getValue()));
        FrontPageAdminPresenterTest.assertFalse((boolean)this.customSupportMessageEnabled);
    }

    private void createAndPresent(String welcomeMessage, String supportMessage) {
        FrontPageAdminPresenter<FrontPageAdminPresenter.Display> presenter = this.createPresenter();
        ((GlobalSettingsAdminRpcServiceAsync)Mockito.doAnswer(invocationOnMock -> {
            ((AsyncCallback)invocationOnMock.getArguments()[0]).onSuccess((Object)new FrontPageMessages(welcomeMessage, supportMessage));
            return null;
        }).when((Object)this.service)).getFrontPageMessages((AsyncCallback)Mockito.any(AsyncCallback.class));
        presenter.present();
    }

    private FrontPageAdminPresenter<FrontPageAdminPresenter.Display> createPresenter() {
        return new FrontPageAdminPresenter(this.service, this.eventBus, this.display);
    }
}

