/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.client.ui.globalsettings.avatar;

import com.atlassian.fecru.gwt.GwtTestUtils;
import com.atlassian.fecru.gwt.admin.client.GlobalSettingsAdminRpcServiceAsync;
import com.atlassian.fecru.gwt.admin.client.ui.globalsettings.avatar.AvatarAdminPresenter;
import com.atlassian.fecru.gwt.admin.client.ui.globalsettings.avatar.events.AvatarAdminEventBus;
import com.atlassian.fecru.gwt.admin.shared.globalsettings.avatar.AvatarUsage;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AvatarAdminPresenterTest
extends TestCase {
    private GlobalSettingsAdminRpcServiceAsync service;
    private AvatarAdminEventBus eventBus;
    private AvatarAdminPresenter.Display display;
    private GwtTestUtils.MockHasClickHandlers saveButton;
    private GwtTestUtils.MockHasClickHandlers revertButton;
    private GwtTestUtils.MockHasValue<Boolean> useInternalRadioButton;
    private GwtTestUtils.MockHasValue<Boolean> useExternalRadioButton;
    private GwtTestUtils.MockHasText externalUrlTextBox;
    private GwtTestUtils.MockHasText externalSuffixTextBox;
    private boolean externalOptionsEnabled;

    protected void setUp() throws Exception {
        this.service = (GlobalSettingsAdminRpcServiceAsync)Mockito.mock(GlobalSettingsAdminRpcServiceAsync.class);
        this.eventBus = new AvatarAdminEventBus((Object)this);
        this.display = (AvatarAdminPresenter.Display)Mockito.mock(AvatarAdminPresenter.Display.class);
        this.saveButton = new GwtTestUtils.MockHasClickHandlers();
        Mockito.when((Object)this.display.getSaveButton()).thenReturn((Object)this.saveButton);
        this.revertButton = new GwtTestUtils.MockHasClickHandlers();
        Mockito.when((Object)this.display.getRevertButton()).thenReturn((Object)this.revertButton);
        this.useInternalRadioButton = new GwtTestUtils.MockHasValue<Boolean>(Boolean.valueOf(false)){

            @Override
            public void setValue(Boolean value) {
                if (value.booleanValue() && AvatarAdminPresenterTest.this.useExternalRadioButton != null) {
                    AvatarAdminPresenterTest.this.useExternalRadioButton.setValue(false);
                }
                super.setValue(value);
            }
        };
        Mockito.when((Object)this.display.getUseInternalRadioButton()).thenReturn(this.useInternalRadioButton);
        this.useExternalRadioButton = new GwtTestUtils.MockHasValue<Boolean>(Boolean.valueOf(false)){

            @Override
            public void setValue(Boolean value) {
                if (value.booleanValue() && AvatarAdminPresenterTest.this.useInternalRadioButton != null) {
                    AvatarAdminPresenterTest.this.useInternalRadioButton.setValue(false);
                }
                super.setValue(value);
            }
        };
        Mockito.when((Object)this.display.getUseExternalRadioButton()).thenReturn(this.useExternalRadioButton);
        this.externalUrlTextBox = new GwtTestUtils.MockHasText();
        Mockito.when((Object)this.display.getExternalUrlTextBox()).thenReturn((Object)this.externalUrlTextBox);
        this.externalSuffixTextBox = new GwtTestUtils.MockHasText();
        Mockito.when((Object)this.display.getExternalSuffixTextBox()).thenReturn((Object)this.externalSuffixTextBox);
        this.useInternalRadioButton.addValueChangeHandler((ValueChangeHandler<Boolean>)((ValueChangeHandler)booleanValueChangeEvent -> this.useExternalRadioButton.setValue(false, false)));
        this.useExternalRadioButton.addValueChangeHandler((ValueChangeHandler<Boolean>)((ValueChangeHandler)booleanValueChangeEvent -> this.useInternalRadioButton.setValue(false, false)));
        ((AvatarAdminPresenter.Display)Mockito.doAnswer(invocationOnMock -> {
            this.externalOptionsEnabled = (Boolean)invocationOnMock.getArguments()[0];
            return null;
        }).when((Object)this.display)).enableAllFields(Mockito.anyBoolean());
    }

    public void testDoesLoadInternalSettingsOnPresent() {
        this.testLoadedState(AvatarUsage.Kind.INTERNAL, null, null, false, true, false, false);
    }

    public void testDoesLoadExternalSettingsOnPresent() {
        this.testLoadedState(AvatarUsage.Kind.EXTERNAL, "foo", "bar", false, false, true, true);
    }

    public void testDoesLoadExternalSettingsWithNullUrlAndSuffixOnPresent() {
        this.testLoadedState(AvatarUsage.Kind.EXTERNAL, null, null, false, false, true, true);
    }

    public void testCanSaveInternalSettings() {
        this.testSaveAfterSelection(this.useInternalRadioButton, AvatarUsage.Kind.INTERNAL, "", "");
    }

    public void testCanSaveExternalSettings() {
        this.testSaveAfterSelection(this.useExternalRadioButton, AvatarUsage.Kind.EXTERNAL, "foo", "bar");
    }

    public void testCanRevertSettings() {
        this.createAndPresent(AvatarUsage.Kind.INTERNAL, null, null);
        boolean[] loadCalled = new boolean[]{false};
        ((GlobalSettingsAdminRpcServiceAsync)Mockito.doAnswer(invocationOnMock -> {
            loadCalled[0] = true;
            ((AsyncCallback)invocationOnMock.getArguments()[0]).onSuccess((Object)new AvatarUsage(AvatarUsage.Kind.INTERNAL, null, null));
            return null;
        }).when((Object)this.service)).getAvatarUsage((AsyncCallback)Matchers.anyObject());
        this.useExternalRadioButton.setValue(true, true);
        this.externalUrlTextBox.setText("foo");
        this.externalSuffixTextBox.setText("bar");
        this.revertButton.click();
        AvatarAdminPresenterTest.assertTrue((boolean)((Boolean)this.useInternalRadioButton.getValue()));
        AvatarAdminPresenterTest.assertFalse((boolean)((Boolean)this.useExternalRadioButton.getValue()));
        AvatarAdminPresenterTest.assertFalse((boolean)this.externalOptionsEnabled);
        AvatarAdminPresenterTest.assertTrue((boolean)loadCalled[0]);
    }

    private void testSaveAfterSelection(GwtTestUtils.MockHasValue<Boolean> buttonToSelect, AvatarUsage.Kind expectedKind, String expectedExternalUrl, String expectedExternalSuffix) {
        this.createAndPresent(AvatarUsage.Kind.INTERNAL, expectedExternalUrl, expectedExternalSuffix);
        boolean[] saveCalled = new boolean[]{false};
        boolean[] eventFired = new boolean[]{false};
        this.eventBus.addAvatarUsageChangedHandler(event -> {
            eventFired[0] = true;
            AvatarAdminPresenterTest.assertSame((Object)expectedKind, (Object)event.getAvatarUsage().getKind());
            AvatarAdminPresenterTest.assertSame((Object)expectedExternalUrl, (Object)event.getAvatarUsage().getExternalUrl());
            AvatarAdminPresenterTest.assertSame((Object)expectedExternalSuffix, (Object)event.getAvatarUsage().getExternalSuffix());
        });
        ((GlobalSettingsAdminRpcServiceAsync)Mockito.doAnswer(invocationOnMock -> {
            saveCalled[0] = true;
            AvatarUsage avatarUsage = (AvatarUsage)invocationOnMock.getArguments()[0];
            AvatarAdminPresenterTest.assertSame((Object)expectedKind, (Object)avatarUsage.getKind());
            AvatarAdminPresenterTest.assertSame((Object)expectedExternalUrl, (Object)avatarUsage.getExternalUrl());
            AvatarAdminPresenterTest.assertSame((Object)expectedExternalSuffix, (Object)avatarUsage.getExternalSuffix());
            ((AsyncCallback)invocationOnMock.getArguments()[1]).onSuccess(null);
            return null;
        }).when((Object)this.service)).setAvatarUsage((AvatarUsage)Matchers.anyObject(), (AsyncCallback)Matchers.anyObject());
        this.externalUrlTextBox.setText(expectedExternalUrl);
        this.externalSuffixTextBox.setText(expectedExternalSuffix);
        buttonToSelect.setValue(true, true);
        this.saveButton.click();
        AvatarAdminPresenterTest.assertTrue((boolean)saveCalled[0]);
    }

    private void testLoadedState(AvatarUsage.Kind avatarUsageKind, String externalUrl, String externalSuffix, boolean disabledSet, boolean internalSet, boolean externalSet, boolean externalOptionsEnabled) {
        this.createAndPresent(avatarUsageKind, externalUrl, externalSuffix);
        AvatarAdminPresenterTest.assertEquals((boolean)internalSet, (boolean)((Boolean)this.display.getUseInternalRadioButton().getValue()));
        AvatarAdminPresenterTest.assertEquals((boolean)externalSet, (boolean)((Boolean)this.display.getUseExternalRadioButton().getValue()));
        AvatarAdminPresenterTest.assertSame((Object)externalOptionsEnabled, (Object)this.externalOptionsEnabled);
        AvatarAdminPresenterTest.assertTrue((String)this.display.getExternalUrlTextBox().getText(), (boolean)(externalUrl == null ? "" : externalUrl).equals(this.display.getExternalUrlTextBox().getText()));
        AvatarAdminPresenterTest.assertTrue((String)this.display.getExternalSuffixTextBox().getText(), (boolean)(externalSuffix == null ? "" : externalSuffix).equals(this.display.getExternalSuffixTextBox().getText()));
    }

    private void createAndPresent(AvatarUsage.Kind avatarUsageKind, String externalUrl, String externalSuffix) {
        ((GlobalSettingsAdminRpcServiceAsync)Mockito.doAnswer(invocationOnMock -> {
            ((AsyncCallback)invocationOnMock.getArguments()[0]).onSuccess((Object)new AvatarUsage(avatarUsageKind, externalUrl, externalSuffix));
            return null;
        }).when((Object)this.service)).getAvatarUsage((AsyncCallback)Matchers.anyObject());
        this.createPresenter();
    }

    private void createPresenter() {
        new AvatarAdminPresenter(this.service, this.eventBus, this.display).present();
    }
}

