/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.client.ui;

import com.atlassian.fecru.gwt.admin.client.ui.ObservedValue;
import com.google.gwt.event.shared.HandlerRegistration;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ObservedValueTest {
    private boolean changed;
    private Integer changedValue;
    private ObservedValue<Integer> value;
    private HandlerRegistration rego;

    @Before
    public void setUp() throws Exception {
        this.changed = false;
        this.changedValue = null;
        this.value = new ObservedValue((Object)this, (Object)1);
        this.rego = this.value.addValueChangeHandler(event -> {
            this.changed = true;
            this.changedValue = (Integer)event.getValue();
        });
    }

    @After
    public void tearDown() throws Exception {
        this.rego.removeHandler();
    }

    @Test
    public void testChangedValue() {
        this.value.setValue((Object)2);
        Assert.assertTrue((boolean)this.changed);
        Assert.assertSame((Object)2, (Object)this.changedValue);
    }

    @Test
    public void testNullValue() {
        this.value.setValue(null);
        Assert.assertTrue((boolean)this.changed);
        Assert.assertSame(null, (Object)this.changedValue);
    }

    @Test
    public void testNoChangeEvent() {
        this.value.setValue((Object)1, false);
        Assert.assertFalse((boolean)this.changed);
        Assert.assertSame(null, (Object)this.changedValue);
    }

    @Test
    public void testHandlerRemoved() {
        this.rego.removeHandler();
        this.value.setValue((Object)3, false);
        Assert.assertFalse((boolean)this.changed);
        Assert.assertSame(null, (Object)this.changedValue);
    }
}

