/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.client;

import com.atlassian.fecru.gwt.admin.client.AsyncAdminCallback;
import com.atlassian.fecru.gwt.admin.shared.AuthorizationException;
import com.atlassian.fecru.gwt.core.client.Spinner;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AsyncAdminCallbackTest
extends TestCase {
    public void testSpinnerStoppedAndStartedOnSuccess() {
        final boolean[] reportErrorCalled = new boolean[]{false};
        LinkedList<Boolean> spinnerStates = new LinkedList<Boolean>();
        Spinner spinner = this.newSpinner(spinnerStates);
        AsyncAdminCallback<Void> async = new AsyncAdminCallback<Void>(spinner){

            protected void success(Void result) {
                throw new RuntimeException();
            }

            protected void reportError(Throwable caught) {
                reportErrorCalled[0] = true;
            }
        };
        async.onSuccess(null);
        AsyncAdminCallbackTest.assertTrue((boolean)((Boolean)spinnerStates.get(0)));
        AsyncAdminCallbackTest.assertFalse((boolean)((Boolean)spinnerStates.get(1)));
    }

    public void testSpinnerStoppedAndStartedOnSuccessWithSubsequentException() {
        final boolean[] reportErrorCalled = new boolean[]{false};
        LinkedList<Boolean> spinnerStates = new LinkedList<Boolean>();
        Spinner spinner = this.newSpinner(spinnerStates);
        AsyncAdminCallback<Void> async = new AsyncAdminCallback<Void>(spinner){

            protected void success(Void result) {
                throw new RuntimeException();
            }

            protected void reportError(Throwable caught) {
                reportErrorCalled[0] = true;
            }
        };
        async.onSuccess(null);
        AsyncAdminCallbackTest.assertTrue((boolean)((Boolean)spinnerStates.get(0)));
        AsyncAdminCallbackTest.assertFalse((boolean)((Boolean)spinnerStates.get(1)));
    }

    public void testSpinnerStoppedAndStartedOnFailure() {
        final boolean[] reportErrorCalled = new boolean[]{false};
        LinkedList<Boolean> spinnerStates = new LinkedList<Boolean>();
        Spinner spinner = this.newSpinner(spinnerStates);
        AsyncAdminCallback<Void> async = new AsyncAdminCallback<Void>(spinner){

            protected void success(Void result) {
            }

            protected void reportError(Throwable caught) {
                reportErrorCalled[0] = true;
            }
        };
        async.onFailure((Throwable)new RuntimeException());
        AsyncAdminCallbackTest.assertTrue((boolean)((Boolean)spinnerStates.get(0)));
        AsyncAdminCallbackTest.assertFalse((boolean)((Boolean)spinnerStates.get(1)));
    }

    public void testHandlesAuthorizationExceptions() {
        final boolean[] failureCalled = new boolean[]{false};
        final boolean[] handleNonAuthCalled = new boolean[]{false};
        AsyncAdminCallback<Void> async = new AsyncAdminCallback<Void>(){

            protected void success(Void result) {
            }

            public void failure(Throwable caught) {
                failureCalled[0] = true;
                super.failure(caught);
            }

            protected void handleNonAuthorisation() {
                handleNonAuthCalled[0] = true;
            }
        };
        async.onFailure((Throwable)new AuthorizationException());
        AsyncAdminCallbackTest.assertTrue((boolean)failureCalled[0]);
        AsyncAdminCallbackTest.assertTrue((boolean)handleNonAuthCalled[0]);
    }

    private Spinner newSpinner(List<Boolean> spinnerStates) {
        Spinner spinner = (Spinner)Mockito.mock(Spinner.class);
        ((Spinner)Mockito.doAnswer(invocationOnMock -> {
            spinnerStates.add((Boolean)invocationOnMock.getArguments()[0]);
            return null;
        }).when((Object)spinner)).showSpinner(Matchers.anyBoolean());
        return spinner;
    }
}

