/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt;

import com.atlassian.fecru.gwt.admin.client.ui.HasSelectedValue;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.AuthOptionsPresenter;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.HasSvnSymbolicRules;
import com.atlassian.fecru.gwt.admin.client.ui.repositories.ScmPasswordPresenter;
import com.atlassian.fecru.gwt.admin.client.ui.widgets.PasswordTextBox;
import com.atlassian.fecru.gwt.admin.shared.repositories.SymbolicRule;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.InlineHyperlink;
import gwtupload.client.IUploader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class GwtTestUtils {
    public static <T extends EventHandler> ArgumentCaptor<T> captureEventHandler(GwtEvent.Type<T> type, Class<T> clazz, HandlerManager mockEventBus) {
        ArgumentCaptor handler = ArgumentCaptor.forClass(clazz);
        Mockito.when((Object)mockEventBus.addHandler((GwtEvent.Type)Matchers.eq(type), (EventHandler)handler.capture())).thenReturn((Object)new HandlerRegistration(){

            public void removeHandler() {
            }
        });
        return handler;
    }

    public static <D> D mockDisplay(Class<D> clazz) {
        final HashMap fields = new HashMap();
        return (D)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object v = fields.get(method.getName());
                if (v == null) {
                    if (method.getReturnType().equals(HasValue.class)) {
                        v = new MockHasValue();
                    } else if (method.getReturnType().equals(HasSelectedValue.class)) {
                        v = new MockHasSelectedValue();
                    } else if (method.getReturnType().equals(AuthOptionsPresenter.Display.class)) {
                        v = GwtTestUtils.mockDisplay(AuthOptionsPresenter.Display.class);
                    } else if (method.getReturnType().equals(ScmPasswordPresenter.Display.class)) {
                        v = GwtTestUtils.mockDisplay(ScmPasswordPresenter.Display.class);
                    } else if (method.getReturnType().equals(HasSvnSymbolicRules.class)) {
                        v = new MockHasSvnSymbolicRules();
                    } else if (method.getReturnType().equals(HasClickHandlers.class)) {
                        v = new MockHasClickHandlers();
                    } else if (method.getReturnType().equals(HasText.class)) {
                        v = new MockHasText();
                    } else if (method.getReturnType().equals(PasswordTextBox.class)) {
                        v = Mockito.mock(PasswordTextBox.class);
                    } else if (method.getReturnType().equals(InlineHyperlink.class)) {
                        v = Mockito.mock(InlineHyperlink.class);
                    } else if (method.getReturnType().equals(IUploader.class)) {
                        v = Mockito.mock(IUploader.class);
                    } else if (!method.getReturnType().equals(Void.TYPE)) {
                        throw new RuntimeException("Unexpected method:" + method.toString());
                    }
                    if (v != null) {
                        fields.put(method.getName(), v);
                    }
                }
                return v;
            }
        });
    }

    public static class MockHasSvnSymbolicRules
    implements HasSvnSymbolicRules {
        List<SymbolicRule> trunkRules;
        List<SymbolicRule> branchRules;
        List<SymbolicRule> tagRules;
        String patternName;

        public List<SymbolicRule> getTrunkRules() {
            return this.trunkRules;
        }

        public List<SymbolicRule> getBranchRules() {
            return this.branchRules;
        }

        public List<SymbolicRule> getTagRules() {
            return this.tagRules;
        }

        public void setRules(String patternName, List<SymbolicRule> trunkRules, List<SymbolicRule> branchRules, List<SymbolicRule> tagRules) {
            this.patternName = patternName;
            this.trunkRules = trunkRules;
            this.branchRules = branchRules;
            this.tagRules = tagRules;
        }

        public boolean isCustomised() {
            return this.patternName == null;
        }
    }

    public static class MockHasSelectedValue<T>
    implements HasSelectedValue<T> {
        private List<T> values = new ArrayList<T>();
        private int selectedIndex = 0;

        public void clear() {
            this.values.clear();
            this.selectedIndex = 0;
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public T getValue(int index) {
            return this.values.get(index);
        }

        public void setValue(int index, String value) {
            throw new RuntimeException("Unimplemented");
        }

        public void setSelectedIndex(int index) {
            this.selectedIndex = index;
        }

        public void addItem(T item, T value) {
            this.values.add(item);
        }

        public void addItem(T item) {
            this.values.add(item);
        }

        public int getItemCount() {
            return this.values.size();
        }

        public void removeItem(int index) {
            this.values.remove(index);
        }

        public HandlerRegistration addChangeHandler(ChangeHandler handler) {
            return null;
        }

        public void fireEvent(GwtEvent<?> event) {
        }
    }

    public static class MockHasClickHandlers
    implements HasClickHandlers {
        private HandlerManager manager = new HandlerManager((Object)this);

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.manager.addHandler((GwtEvent.Type)ClickEvent.getType(), (EventHandler)handler);
        }

        public void fireEvent(GwtEvent<?> event) {
            this.manager.fireEvent(event);
        }

        public void click() {
            this.manager.fireEvent((GwtEvent)this.newClickEvent());
        }

        private ClickEvent newClickEvent() {
            try {
                Constructor ctor = ClickEvent.class.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                return (ClickEvent)ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class MockHasText
    extends Recorder<String>
    implements HasText {
        public MockHasText() {
            this.setValue("");
        }

        public String getText() {
            return (String)this.getValue();
        }

        public void setText(String text) {
            this.setValue(text);
        }
    }

    public static class MockHasHTML
    extends Recorder<String>
    implements HasHTML {
        public String getHTML() {
            return (String)this.getValue();
        }

        public void setHTML(String html) {
            this.setValue(html);
        }

        public String getText() {
            return (String)this.getValue();
        }

        public void setText(String text) {
            this.setValue(text);
        }
    }

    public static class MockHasValue<T>
    extends Recorder<T>
    implements HasValue<T> {
        HandlerManager manager = new HandlerManager((Object)this);

        public MockHasValue() {
            this(null);
        }

        public MockHasValue(T value) {
            this.setValue(value);
        }

        public void setValue(T value, boolean fireEvents) {
            this.setValue(value);
            if (fireEvents) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, value);
            }
        }

        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<T> handler) {
            return this.manager.addHandler(ValueChangeEvent.getType(), handler);
        }

        public void fireEvent(GwtEvent<?> event) {
            this.manager.fireEvent(event);
        }
    }

    public static class Recorder<T> {
        private T v;

        public void setValue(T t) {
            this.v = t;
        }

        public T getValue() {
            return this.v;
        }
    }
}

