/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.filter.rewrite;

import com.atlassian.fecru.filter.rewrite.FisheyeResourceDownloadRewriteRule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.tuckey.web.filters.urlrewrite.extend.RewriteMatch;

@RunWith(value=MockitoJUnitRunner.class)
public class FisheyeResourceDownloadRewriteRuleTest {
    private FisheyeResourceDownloadRewriteRule rule = new FisheyeResourceDownloadRewriteRule();
    @Mock
    HttpServletRequest request;
    @Mock
    HttpServletResponse response;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.request.getContextPath()).thenReturn((Object)"/foo");
    }

    @Test
    public void testRewrite() throws Exception {
        this.mockRequest("/foo/s/-418945332/SNAPSHOT/1/5.0-fecru2/_/download/batch/com.atlassian.auiplugin:aui-experimental-spinner/com.atlassian.auiplugin:aui-experimental-spinner.js");
        RewriteMatch match = this.rule.matches(this.request, this.response);
        Assert.assertEquals((Object)"/foo/download/batch/com.atlassian.auiplugin:aui-experimental-spinner/com.atlassian.auiplugin:aui-experimental-spinner.js", (Object)match.getMatchingUrl());
    }

    @Test
    public void testDisallowPathTraversalOutOfContainer() throws Exception {
        this.mockRequest("/foo/s/-418945332/_/../../../../config.xml");
        RewriteMatch match = this.rule.matches(this.request, this.response);
        Assert.assertNull((Object)match);
    }

    @Test
    public void testAllowValidPathTraversal() throws Exception {
        this.mockRequest("/foo/s/-418945332/SNAPSHOT/1/5.0-fecru2/_/download/batch/../images/icons/wait.gif");
        RewriteMatch match = this.rule.matches(this.request, this.response);
        Assert.assertEquals((Object)"/foo/download/images/icons/wait.gif", (Object)match.getMatchingUrl());
    }

    @Test
    public void testDisallowWebInf() throws Exception {
        this.mockRequest("/foo/s/-418945332/SNAPSHOT/1/5.0-fecru2/_/WEB-INF/web.xml");
        RewriteMatch match = this.rule.matches(this.request, this.response);
        Assert.assertNull((Object)match);
    }

    @Test
    public void testDisallowWebInfLowercase() throws Exception {
        this.mockRequest("/foo/s/-418945332/SNAPSHOT/1/5.0-fecru2/_/web-inf/web.xml");
        RewriteMatch match = this.rule.matches(this.request, this.response);
        Assert.assertNull((Object)match);
    }

    @Test
    public void testDisallowTraversalToWebInf() throws Exception {
        this.mockRequest("/foo/s/-418945332/SNAPSHOT/1/5.0-fecru2/_/download/../WEB-INF/secret.properties");
        RewriteMatch match = this.rule.matches(this.request, this.response);
        Assert.assertNull((Object)match);
    }

    private void mockRequest(String uri) {
        Mockito.when((Object)this.request.getRequestURI()).thenReturn((Object)uri);
    }
}

