/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.dbtest;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserPermissionsTestRule;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Query;
import org.hibernate.Session;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public final class UserManagementTest {
    private final List<String> usersToDelete = new ArrayList<String>();
    private UserManager userManager;
    private UserProfileManager userProfileManager;
    private UserPermissionsTestRule userPermissionsTestRule;

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        TestFishEyeInstances.loadSanity1();
        this.userManager = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.userProfileManager = (UserProfileManager)SpringContext.getComponentByClass(UserProfileManager.class);
        this.userPermissionsTestRule = (UserPermissionsTestRule)((Object)SpringContext.createComponent(UserPermissionsTestRule.class));
        this.userPermissionsTestRule.before();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.deleteUsers();
            this.userPermissionsTestRule.after();
            HibernateUtil.closeSession();
            Disposer.popThreadInstance();
        }
        finally {
            TestFishEyeInstances.stop();
        }
    }

    public void deleteUsers() throws Exception {
        for (String username : this.usersToDelete) {
            this.userManager.deleteUserFully(username);
        }
    }

    @Test
    public void testTimezoneNullByDefault() throws Exception {
        String username = "testTimezoneNullByDefault";
        this.usersToDelete.add("testTimezoneNullByDefault");
        this.userPermissionsTestRule.addFisheyeUser("testTimezoneNullByDefault");
        this.commitAndClearSession();
        FecruUser fetchedUser = this.userManager.getLicensedUser("testTimezoneNullByDefault");
        UserProfile fetchedProfile = fetchedUser.getUserProfile();
        Assert.assertThat((String)"by default null (server default timezone)", (Object)fetchedProfile.getTimezone(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testTimezoneSet() throws Exception {
        String username = "testSetTimezone";
        this.usersToDelete.add("testSetTimezone");
        this.userPermissionsTestRule.addFisheyeUser("testSetTimezone");
        UserProfile profile = this.userProfileManager.getProfile("testSetTimezone");
        profile.setTimezone("Singapore");
        this.userProfileManager.setProfile("testSetTimezone", profile);
        this.commitAndClearSession();
        FecruUser fetchedUser = this.userManager.getLicensedUser("testSetTimezone");
        UserProfile fetchedProfile = fetchedUser.getUserProfile();
        Assert.assertThat((Object)fetchedProfile.getTimezone(), (Matcher)Matchers.equalTo((Object)"Singapore"));
    }

    @Test
    public void testTimezoneResetToDefault() throws Exception {
        String username = "testResetTimezoneToDefault";
        this.usersToDelete.add("testResetTimezoneToDefault");
        this.userPermissionsTestRule.addFisheyeUser("testResetTimezoneToDefault");
        UserProfile profile = this.userProfileManager.getProfile("testResetTimezoneToDefault");
        profile.setTimezone("Singapore");
        this.userProfileManager.setProfile("testResetTimezoneToDefault", profile);
        profile = this.userProfileManager.getProfile("testResetTimezoneToDefault");
        profile.setTimezone(null);
        this.userProfileManager.setProfile("testResetTimezoneToDefault", profile);
        this.commitAndClearSession();
        FecruUser fetchedUser = this.userManager.getLicensedUser("testResetTimezoneToDefault");
        UserProfile fetchedProfile = fetchedUser.getUserProfile();
        Assert.assertThat((String)"null (server default timezone)", (Object)fetchedProfile.getTimezone(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetUserAndProfile() throws Exception {
        String username = "testGetUserAndProfile";
        this.usersToDelete.add("testGetUserAndProfile");
        this.userPermissionsTestRule.addFisheyeUser("testGetUserAndProfile");
        FecruUser fetchedUser = this.userManager.getLicensedUser("testGetUserAndProfile");
        UserProfile fetchedProfile = fetchedUser.getUserProfile();
        Assert.assertTrue((fetchedUser.getId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testGetUserAndProfile", (Object)fetchedUser.getUsername());
        Assert.assertNotNull((Object)fetchedProfile);
        Assert.assertNotNull((Object)fetchedProfile.getUser());
        Assert.assertEquals((Object)fetchedUser.getId(), (Object)fetchedProfile.getUser().getId());
    }

    @Test
    public void testGetUserAndProfileFromManagers() throws Exception {
        String username = "testGetUserAndProfileFromManagers";
        this.usersToDelete.add("testGetUserAndProfileFromManagers");
        this.userPermissionsTestRule.addFisheyeUser("testGetUserAndProfileFromManagers");
        FecruUser fetchedUser = this.userManager.getLicensedUser("testGetUserAndProfileFromManagers");
        UserProfile fetchedProfile = fetchedUser.getUserProfile();
        UserProfile fetchedProfile2 = this.userProfileManager.getProfile("testGetUserAndProfileFromManagers");
        Assert.assertNotNull((Object)fetchedProfile);
        Assert.assertNotNull((Object)fetchedProfile.getUser());
        Assert.assertNotNull((Object)fetchedProfile2);
        Assert.assertNotNull((Object)fetchedProfile2.getUser());
        Assert.assertEquals((Object)fetchedUser.getId(), (Object)fetchedProfile.getUser().getId());
        Assert.assertEquals((Object)fetchedUser.getId(), (Object)fetchedProfile.getUser().getId());
    }

    @Test
    public void testDeleteUser() throws Exception {
        String username = "testDeleteUser";
        this.userPermissionsTestRule.addFisheyeUser("testDeleteUser");
        FecruUser fetchedUser = this.userManager.getLicensedUser("testDeleteUser");
        Assert.assertNotNull((Object)fetchedUser);
        Assert.assertNotNull((Object)fetchedUser.getUserProfile());
        this.userManager.deleteUserFully("testDeleteUser");
        Assert.assertNull((Object)this.userManager.getLicensedUser("testDeleteUser"));
        try {
            this.userProfileManager.getProfile("testDeleteUser");
            Assert.fail((String)"Profile should not have been found for user testDeleteUser");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Unknown user: testDeleteUser", (Object)e.getMessage());
        }
    }

    @Test
    @Ignore
    public void testUpdateProfile() throws Exception {
        String username = "testUpdateProfile";
        this.usersToDelete.add("testUpdateProfile");
        FecruUser user = this.userPermissionsTestRule.addFisheyeUser("testUpdateProfile");
        UserProfile profile = new UserProfile();
        profile.setTabwidth(21);
        profile.setContext(42);
        this.userProfileManager.setProfile("testUpdateProfile", profile);
        UserProfile createdProfile = this.checkProfileExists(user);
        Assert.assertNotNull((Object)createdProfile);
        Assert.assertEquals((long)profile.getTabwidth(), (long)createdProfile.getTabwidth());
        Assert.assertEquals((long)profile.getContext(), (long)createdProfile.getContext());
        UserProfile fetchedProfile = this.userProfileManager.getProfile("testUpdateProfile");
        Assert.assertNotNull((Object)fetchedProfile);
        Assert.assertEquals((long)profile.getTabwidth(), (long)fetchedProfile.getTabwidth());
        Assert.assertEquals((long)profile.getContext(), (long)fetchedProfile.getContext());
        FecruUser fetchedUser = this.userManager.getLicensedUser("testUpdateProfile");
        UserProfile fetchedProfileFromUser = fetchedUser.getUserProfile();
        Assert.assertNotNull((Object)fetchedProfileFromUser);
        Assert.assertEquals((long)profile.getTabwidth(), (long)fetchedProfileFromUser.getTabwidth());
        Assert.assertEquals((long)profile.getContext(), (long)fetchedProfileFromUser.getContext());
    }

    private UserProfile checkProfileExists(FecruUser user) {
        Session session = HibernateUtil.currentSession();
        Query query = session.createQuery("from UserProfile where userId = (select id from FecruUser where username = :username)");
        query.setString("username", user.getUsername());
        return (UserProfile)query.uniqueResult();
    }

    private void commitAndClearSession() {
        HibernateUtil.bounceTransaction();
        HibernateUtil.clearSession();
    }
}

