/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.checkouturl.impl;

import com.atlassian.fecru.checkouturl.impl.CheckoutUrl;
import com.atlassian.fisheye.spi.admin.data.P4RepositoryData;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.data.SvnRepositoryData;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.svn.SvnScmConfig;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CheckoutUrlTest {
    @Test
    public void testP4Escaping() {
        P4RepositoryData data = new P4RepositoryData("testp4", "http://foo/ourrepo", "the path@#*%");
        Map map = CheckoutUrl.P4.checkoutUrlFromRepositoryData((RepositoryData)data);
        Assert.assertEquals((Object)"the path%40%23%2A%25", map.get("Path"));
    }

    @Test
    public void testSvn() {
        this.testSvnURL("file://foo", "bar", null);
        this.testSvnURL("foo", "bar", null);
        this.testSvnURL("http://foo", "bar", "http://foo/bar");
        this.testSvnURL("http://foo/", "/bar/", "http://foo/bar");
        this.testSvnURL("http://foo/", "/b a r/", "http://foo/b%20a%20r");
        this.testSvnURL("http://foo/", "bar/./baz", "http://foo/bar/baz");
        this.testSvnURL("http://foo/", "bar/../baz", "http://foo/baz");
        this.testSvnURL("svn://foo/", "bar", "svn://foo/bar");
    }

    private void testSvnURL(String url, String path, String result) {
        SvnRepositoryData data = new SvnRepositoryData("test", url);
        data.setPath(path);
        Assert.assertEquals((Object)result, CheckoutUrl.SVN.checkoutUrlFromRepositoryData((RepositoryData)data).get("URL"));
        RepositoryConfig config = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        SvnScmConfig svnConfig = (SvnScmConfig)Mockito.mock(SvnScmConfig.class);
        Mockito.when((Object)config.getScmConfig()).thenReturn((Object)svnConfig);
        Mockito.when((Object)svnConfig.getRepoUrl()).thenReturn((Object)url);
        Mockito.when((Object)svnConfig.getRepoPath()).thenReturn((Object)path);
        Assert.assertEquals((Object)result, CheckoutUrl.SVN.checkoutUrlFromVCS(config, null).get("URL"));
    }
}

