/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.analytics.collector;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.fecru.analytics.collector.DefaultUserManagementStatisticsService;
import com.atlassian.fecru.analytics.collector.UserManagementStatisticsService;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.config1.AjpAuthConfigType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CustomSecurityConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultUserManagementStatisticsServiceTest {
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    @Mock
    private CrowdDirectoryService crowdDirectoryService;
    @Mock
    private ApplicationManager applicationManager;
    @Mock
    private SecurityType security;
    @Mock
    private AjpAuthConfigType ajp;
    @Mock
    private CustomSecurityConfigType custom;
    private UserManagementStatisticsService userManagementStatsService;

    @Before
    public void setUp() throws Exception {
        RootConfig rootConfig = this.rootConfigRule.getRootConfig();
        this.userManagementStatsService = new DefaultUserManagementStatisticsService(this.crowdDirectoryService, this.applicationManager, rootConfig);
        ConfigDocument.Config config = (ConfigDocument.Config)Mockito.mock(ConfigDocument.Config.class);
        Mockito.when((Object)rootConfig.getConfig()).thenReturn((Object)config);
        Mockito.when((Object)config.getSecurity()).thenReturn((Object)this.security);
    }

    @Test
    public void testAjpAutoAddWhenOn() throws Exception {
        Mockito.when((Object)this.security.isSetAjp()).thenReturn((Object)true);
        Mockito.when((Object)this.security.getAjp()).thenReturn((Object)this.ajp);
        Mockito.when((Object)this.ajp.getAutoAdd()).thenReturn((Object)true);
        Optional ajpAutoAdd = this.userManagementStatsService.getAjpAutoAdd();
        Assert.assertTrue((boolean)ajpAutoAdd.orElse(false));
    }

    @Test
    public void testAjpAutoAddWhenOff() throws Exception {
        Mockito.when((Object)this.security.isSetAjp()).thenReturn((Object)true);
        Mockito.when((Object)this.security.getAjp()).thenReturn((Object)this.ajp);
        Mockito.when((Object)this.ajp.getAutoAdd()).thenReturn((Object)false);
        Optional ajpAutoAdd = this.userManagementStatsService.getAjpAutoAdd();
        Assert.assertFalse((boolean)ajpAutoAdd.orElse(true));
    }

    @Test
    public void testAjpAutoAddWhenAjpNotSet() throws Exception {
        Mockito.when((Object)this.security.isSetAjp()).thenReturn((Object)false);
        Optional result = this.userManagementStatsService.getAjpAutoAdd();
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCustomAutoAddWhenOn() throws Exception {
        Mockito.when((Object)this.security.isSetCustom()).thenReturn((Object)true);
        Mockito.when((Object)this.security.getCustom()).thenReturn((Object)this.custom);
        Mockito.when((Object)this.custom.getAutoAdd()).thenReturn((Object)true);
        Optional result = this.userManagementStatsService.getCustomAutoAdd();
        Assert.assertTrue((boolean)result.orElse(false));
    }

    @Test
    public void testCustomAutoAddWhenOff() throws Exception {
        Mockito.when((Object)this.security.isSetCustom()).thenReturn((Object)true);
        Mockito.when((Object)this.security.getCustom()).thenReturn((Object)this.custom);
        Mockito.when((Object)this.custom.getAutoAdd()).thenReturn((Object)false);
        Optional result = this.userManagementStatsService.getCustomAutoAdd();
        Assert.assertFalse((boolean)result.orElse(true));
    }

    @Test
    public void testCustomAutoAddWhenCustomNotSet() throws Exception {
        Mockito.when((Object)this.security.isSetCustom()).thenReturn((Object)false);
        Optional result = this.userManagementStatsService.getCustomAutoAdd();
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testInternalDirectoryEnabled() throws Exception {
        Directory directory = (Directory)Mockito.mock(Directory.class);
        Mockito.when((Object)directory.getType()).thenReturn((Object)DirectoryType.INTERNAL);
        Mockito.when((Object)directory.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.crowdDirectoryService.findAllDirectories()).thenReturn((Object)ImmutableList.of((Object)directory));
        boolean shouldBeEnabled = this.userManagementStatsService.isInternalDirectoryEnabled();
        Mockito.when((Object)directory.isActive()).thenReturn((Object)false);
        boolean shouldBeDisabled = this.userManagementStatsService.isInternalDirectoryEnabled();
        Assert.assertTrue((boolean)shouldBeEnabled);
        Assert.assertFalse((boolean)shouldBeDisabled);
    }

    @Test
    public void testApplicationAttrsWhenAppExists() throws Exception {
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)application.getAttributes()).thenReturn((Object)ImmutableMap.of((Object)"mockedData", (Object)"true"));
        Mockito.when((Object)this.applicationManager.findById(1L)).thenReturn((Object)application);
        Map result = this.userManagementStatsService.getCrowdApplicationAttributes();
        Assert.assertThat((Object)result, (Matcher)Matchers.hasEntry((Object)"mockedData", (Object)"true"));
    }

    @Test
    public void testApplicationAttrsWhenAppNotExists() throws Exception {
        Mockito.when((Object)this.applicationManager.findById(1L)).thenThrow(new Class[]{ApplicationNotFoundException.class});
        Map result = this.userManagementStatsService.getCrowdApplicationAttributes();
        Assert.assertThat(result.entrySet(), (Matcher)Matchers.empty());
    }

    @Test
    public void testDirectoryTypesStats() throws Exception {
        ArrayList directories = Lists.newArrayList((Object[])new Directory[]{this.mockDirectory(DirectoryType.INTERNAL), this.mockDirectory(DirectoryType.CONNECTOR), this.mockDirectory(DirectoryType.CONNECTOR), this.mockDirectory(DirectoryType.CONNECTOR), this.mockDirectory(DirectoryType.CUSTOM), this.mockDirectory(DirectoryType.DELEGATING), this.mockDirectory(DirectoryType.CROWD), this.mockDirectory(DirectoryType.CROWD), this.mockDirectory(DirectoryType.CROWD), this.mockDirectory(DirectoryType.CROWD)});
        Directory notActive = (Directory)Mockito.mock(Directory.class);
        Mockito.when((Object)notActive.isActive()).thenReturn((Object)false);
        Mockito.when((Object)notActive.getType()).thenReturn((Object)DirectoryType.CROWD);
        directories.add(notActive);
        Mockito.when((Object)this.crowdDirectoryService.findAllDirectories()).thenReturn((Object)directories);
        Map result = this.userManagementStatsService.getDirectoryTypesStatistics();
        Assert.assertThat((Object)result, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"unknown", (Object)0), Matchers.hasEntry((Object)"internal", (Object)1), Matchers.hasEntry((Object)"connector", (Object)3), Matchers.hasEntry((Object)"custom", (Object)1), Matchers.hasEntry((Object)"delegating", (Object)1), Matchers.hasEntry((Object)"crowd", (Object)4), Matchers.hasEntry((Object)"total", (Object)10)}));
    }

    private Directory mockDirectory(DirectoryType type) {
        Directory directory = (Directory)Mockito.mock(Directory.class);
        Mockito.when((Object)directory.getType()).thenReturn((Object)type);
        Mockito.when((Object)directory.isActive()).thenReturn((Object)true);
        return directory;
    }
}

