/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.activityitem.logitem;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.fecru.activityitem.ActivityItemData;
import com.atlassian.fecru.activityitem.ActivityItemDataService;
import com.atlassian.fecru.activityitem.ActivityItemSearchCriteria;
import com.atlassian.fecru.activityitem.logitem.LogItemActivityItemDataService;
import com.atlassian.fecru.activityitem.logitem.LogItemConverter;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.LogItemSearchCriteria;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class LogItemActivityItemDataServiceTest {
    private ReviewService reviewServiceMock;
    private ReviewManager reviewManagerMock;
    private LogItemManager logItemManagerMock;
    private LogItemActivityItemDataService logItemActivityItemDataService;

    @Before
    public void setUp() {
        this.reviewServiceMock = (ReviewService)Mockito.mock(ReviewService.class);
        this.reviewManagerMock = (ReviewManager)Mockito.mock(ReviewManager.class);
        this.logItemManagerMock = (LogItemManager)Mockito.mock(LogItemManager.class);
        Function<LogItem, ActivityItemData> convertFunction1 = logItem -> new ActivityItemData.ActivityItemDataBuilder(ActivityItemDataService.Type.REVIEW_CREATED).id((Serializable)logItem.getId()).user(new UserData("magic")).created(ZonedDateTime.now()).build();
        LogItemConverter logItemConverter1 = this.create(ActivityItemDataService.Type.REVIEW_CREATED, (Set<String>)ImmutableSet.of((Object)"action1"), convertFunction1);
        LogItemConverter logItemConverter2 = this.create(ActivityItemDataService.Type.REVIEW_STATE_CHANGE, (Set<String>)ImmutableSet.of((Object)"action2"), null);
        LogItemConverter logItemConverter3 = this.create(ActivityItemDataService.Type.REVIEW_COMPLETED, (Set<String>)ImmutableSet.of((Object)"action3", (Object)"action4"), null);
        this.logItemActivityItemDataService = new LogItemActivityItemDataService(this.reviewServiceMock, this.reviewManagerMock, this.logItemManagerMock, (List)ImmutableList.of((Object)logItemConverter1, (Object)logItemConverter2, (Object)logItemConverter3));
    }

    @Test
    public void testCreationLegalParams() throws Exception {
        LogItemConverter logItemConverter1 = this.create(ActivityItemDataService.Type.REVIEW_CREATED, (Set<String>)ImmutableSet.of((Object)"action1"), null);
        LogItemConverter logItemConverter2 = this.create(ActivityItemDataService.Type.REVIEW_STATE_CHANGE, (Set<String>)ImmutableSet.of((Object)"action2"), null);
        LogItemConverter logItemConverter3 = this.create(ActivityItemDataService.Type.REVIEW_COMPLETED, (Set<String>)ImmutableSet.of((Object)"action3", (Object)"action4"), null);
        new LogItemActivityItemDataService(this.reviewServiceMock, this.reviewManagerMock, this.logItemManagerMock, (List)ImmutableList.of((Object)logItemConverter1, (Object)logItemConverter2, (Object)logItemConverter3));
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreationWithMultipleConvertersForSameType() throws Exception {
        LogItemConverter logItemConverter1 = this.create(ActivityItemDataService.Type.REVIEW_CREATED, (Set<String>)ImmutableSet.of((Object)"action1"), null);
        LogItemConverter logItemConverter2 = this.create(ActivityItemDataService.Type.REVIEW_STATE_CHANGE, (Set<String>)ImmutableSet.of((Object)"action2"), null);
        LogItemConverter logItemConverter3 = this.create(ActivityItemDataService.Type.REVIEW_STATE_CHANGE, (Set<String>)ImmutableSet.of((Object)"action3"), null);
        new LogItemActivityItemDataService(this.reviewServiceMock, this.reviewManagerMock, this.logItemManagerMock, (List)ImmutableList.of((Object)logItemConverter1, (Object)logItemConverter2, (Object)logItemConverter3));
    }

    @Test(expected=IllegalStateException.class)
    public void testCreationWithMultipleConvertersForSameAction() throws Exception {
        LogItemConverter logItemConverter1 = this.create(ActivityItemDataService.Type.REVIEW_CREATED, (Set<String>)ImmutableSet.of((Object)"action1"), null);
        LogItemConverter logItemConverter2 = this.create(ActivityItemDataService.Type.REVIEW_STATE_CHANGE, (Set<String>)ImmutableSet.of((Object)"action2"), null);
        LogItemConverter logItemConverter3 = this.create(ActivityItemDataService.Type.REVIEW_COMPLETED, (Set<String>)ImmutableSet.of((Object)"action2", (Object)"action3"), null);
        new LogItemActivityItemDataService(this.reviewServiceMock, this.reviewManagerMock, this.logItemManagerMock, (List)ImmutableList.of((Object)logItemConverter1, (Object)logItemConverter2, (Object)logItemConverter3));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListNoReviewPermIdFails() throws Exception {
        this.logItemActivityItemDataService.list(ActivityItemSearchCriteria.create(null), PageRequest.createDefault());
    }

    @Test(expected=NotPermittedException.class)
    public void testListNoViewPermission() throws Exception {
        Mockito.when((Object)this.reviewServiceMock.hasPermission(new PermId("CR-1"), UserActionManager.ACTION_VIEW)).thenReturn((Object)false);
        this.logItemActivityItemDataService.list(ActivityItemSearchCriteria.create((String)"CR-1"), PageRequest.createDefault());
    }

    @Test
    public void testList() throws Exception {
        final int reviewId = 10;
        int userId = 100;
        Mockito.when((Object)this.reviewServiceMock.hasPermission(new PermId("CR-1"), UserActionManager.ACTION_VIEW)).thenReturn((Object)true);
        Mockito.when((Object)this.reviewManagerMock.getReviewByPermaId("CR-1")).thenReturn((Object)new Review(){

            public Integer getId() {
                return reviewId;
            }
        });
        ArgumentCaptor logItemSearchCriteriaArgumentCaptor = ArgumentCaptor.forClass(LogItemSearchCriteria.class);
        LogItem logItem = new LogItem("action1", Integer.valueOf(reviewId), Integer.valueOf(userId), "entityString", Integer.valueOf(200), "oldValue", "newValue");
        logItem.setId(Integer.valueOf(99));
        Mockito.when((Object)this.logItemManagerMock.getLogItems((LogItemSearchCriteria)logItemSearchCriteriaArgumentCaptor.capture())).thenReturn((Object)ImmutableList.of((Object)logItem));
        Page pageResult = this.logItemActivityItemDataService.list(ActivityItemSearchCriteria.create((String)"CR-1"), PageRequest.createDefault());
        MatcherAssert.assertThat((Object)pageResult.getValues(), (Matcher)IsIterableWithSize.iterableWithSize((int)1));
        MatcherAssert.assertThat((Object)((LogItemSearchCriteria)logItemSearchCriteriaArgumentCaptor.getValue()).getReviewIds(), (Matcher)IsCollectionContaining.hasItems((Object[])new Integer[]{reviewId}));
        MatcherAssert.assertThat((Object)((LogItemSearchCriteria)logItemSearchCriteriaArgumentCaptor.getValue()).getActions(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"action1"}));
    }

    private LogItemConverter create(final ActivityItemDataService.Type type, final Set<String> actions, final Function<LogItem, ActivityItemData> function) {
        return new LogItemConverter(){

            public ActivityItemDataService.Type type() {
                return type;
            }

            public Set<String> actions() {
                return actions;
            }

            public ActivityItemData apply(LogItem logItem) {
                return (ActivityItemData)function.apply(logItem);
            }
        };
    }
}

