/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.activityitem.logitem;

import com.atlassian.fecru.activityitem.ActivityItemData;
import com.atlassian.fecru.activityitem.ActivityItemDataService;
import com.atlassian.fecru.activityitem.logitem.AbstractLoginItemConverter;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.web.RequestContext;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.fisheye.config.ConfigParameters;
import com.cenqua.fisheye.config.RootConfigRule;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class AbstractLoginItemConverterTest {
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();
    private AbstractLoginItemConverter abstractLoginItemConverter;
    private UserManager userManagerMock;
    private RequestContext requestContextMock;
    private FecruUser user10;
    private ActivityItemDataService.Type logItemType = ActivityItemDataService.Type.REVIEW_CREATED;
    private String action;
    private LogItem logItem;
    private String configSiteUrl = "http://fecru:8080";
    private String configContext = "";

    @Before
    public void setUp() throws Exception {
        this.action = "action1";
        this.abstractLoginItemConverter = new AbstractLoginItemConverter(){

            @Nullable
            protected Map<String, Serializable> getCustomDataFor(LogItem logItem) {
                return null;
            }

            public ActivityItemDataService.Type type() {
                return AbstractLoginItemConverterTest.this.logItemType;
            }

            public Set<String> actions() {
                return ImmutableSet.of((Object)AbstractLoginItemConverterTest.this.action);
            }
        };
        this.requestContextMock = (RequestContext)Mockito.mock(RequestContext.class);
        this.user10 = new FecruUser(Integer.valueOf(10), "user10");
        this.userManagerMock = (UserManager)Mockito.mock(UserManager.class);
        Mockito.when((Object)this.userManagerMock.getUserById(this.user10.getId().intValue())).thenReturn((Object)this.user10);
        this.abstractLoginItemConverter.setUserManager(this.userManagerMock);
        this.abstractLoginItemConverter.setRequestContext(this.requestContextMock);
        this.logItem = new LogItem(this.action, null, this.user10.getId(), null, null, null, null);
        this.logItem.setCreateDate(new Date());
        this.logItem.setId(Integer.valueOf(99));
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getContextPath()).thenReturn((Object)this.configContext);
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getSiteURL()).thenReturn((Object)this.configSiteUrl);
        ConfigParameters configParameters = (ConfigParameters)Mockito.mock(ConfigParameters.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)configParameters.getSiteURL()).thenReturn((Object)this.configSiteUrl);
        Mockito.when((Object)configParameters.getAvatarType().isSetUrl()).thenReturn((Object)false);
        new AvatarTypeInfo(configParameters);
    }

    @Test
    public void testApplyWhenNoRequestAvailable() throws Exception {
        Mockito.when((Object)this.requestContextMock.getRequest()).thenReturn(Optional.empty());
        ActivityItemData activityItemData = this.abstractLoginItemConverter.apply(this.logItem);
        Assert.assertThat((Object)activityItemData.type, (Matcher)CoreMatchers.equalTo((Object)this.logItemType));
        Assert.assertThat((Object)activityItemData.created.toInstant().toEpochMilli(), (Matcher)CoreMatchers.equalTo((Object)this.logItem.getCreateDateTime()));
        Assert.assertThat((Object)activityItemData.id, (Matcher)CoreMatchers.equalTo((Object)("logItem" + this.logItem.getId())));
        Assert.assertThat((Object)activityItemData.user, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)activityItemData.user.getUserName(), (Matcher)CoreMatchers.equalTo((Object)this.user10.getUsername()));
        Assert.assertThat((Object)activityItemData.user.getDisplayName(), (Matcher)CoreMatchers.equalTo((Object)this.user10.getDisplayName()));
        Assert.assertThat((Object)activityItemData.user.getAvatarUrl(), (Matcher)StringStartsWith.startsWith((String)this.configSiteUrl));
    }

    @Test
    public void testApplyWhenRequestAvailable() throws Exception {
        HttpServletRequest httpServletRequestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequestMock.getScheme()).thenReturn((Object)"https");
        Mockito.when((Object)httpServletRequestMock.getServerName()).thenReturn((Object)"MY_FECRU");
        Mockito.when((Object)httpServletRequestMock.getServerPort()).thenReturn((Object)443);
        Mockito.when((Object)httpServletRequestMock.getContextPath()).thenReturn((Object)"/mycontext");
        Mockito.when((Object)this.requestContextMock.getRequest()).thenReturn(Optional.of(httpServletRequestMock));
        ActivityItemData activityItemData = this.abstractLoginItemConverter.apply(this.logItem);
        Assert.assertThat((Object)activityItemData.user, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)activityItemData.user.getUserName(), (Matcher)CoreMatchers.equalTo((Object)this.user10.getUsername()));
        Assert.assertThat((Object)activityItemData.user.getDisplayName(), (Matcher)CoreMatchers.equalTo((Object)this.user10.getDisplayName()));
        Assert.assertThat((Object)activityItemData.user.getAvatarUrl(), (Matcher)StringStartsWith.startsWith((String)"https://MY_FECRU/mycontext"));
    }
}

