/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.actions.analytics;

import com.atlassian.fecru.actions.analytics.ApproximateCount;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class ApproximateCountTest {
    @Test
    public void unknownRangeShouldBeEmpty() throws Exception {
        Assert.assertTrue((boolean)ApproximateCount.UNKNOWN.range.isEmpty());
    }

    @Test
    public void rangesShouldBeConnected() throws Exception {
        for (int i = 1; i < ApproximateCount.values().length; ++i) {
            ApproximateCount current = ApproximateCount.values()[i];
            if (current == ApproximateCount.UNKNOWN) continue;
            ApproximateCount previous = ApproximateCount.values()[i - 1];
            Assert.assertThat((String)(previous + " and " + current + " are not connected ranges"), (Object)current.range.isConnected(previous.range), (Matcher)Is.is((Object)true));
            Assert.assertThat((String)(previous + " and " + current + " are not disjoint ranges"), (Object)current.range.intersection(previous.range).isEmpty(), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void testCount() throws Exception {
        Assert.assertThat((Object)ApproximateCount.fromInt((int)Integer.MIN_VALUE), (Matcher)Is.is((Object)ApproximateCount.UNKNOWN));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)-99), (Matcher)Is.is((Object)ApproximateCount.UNKNOWN));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)-1), (Matcher)Is.is((Object)ApproximateCount.UNKNOWN));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)0), (Matcher)Is.is((Object)ApproximateCount.ZERO));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)1), (Matcher)Is.is((Object)ApproximateCount.TEN_OR_LESS));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)3), (Matcher)Is.is((Object)ApproximateCount.TEN_OR_LESS));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)7), (Matcher)Is.is((Object)ApproximateCount.TEN_OR_LESS));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)9), (Matcher)Is.is((Object)ApproximateCount.TEN_OR_LESS));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)10), (Matcher)Is.is((Object)ApproximateCount.TEN_OR_LESS));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)11), (Matcher)Is.is((Object)ApproximateCount.OVER_TEN));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)20), (Matcher)Is.is((Object)ApproximateCount.OVER_TEN));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)50), (Matcher)Is.is((Object)ApproximateCount.OVER_TEN));
        Assert.assertThat((Object)ApproximateCount.fromInt((int)Integer.MAX_VALUE), (Matcher)Is.is((Object)ApproximateCount.OVER_TEN));
    }
}

