/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.wikirenderer.macro;

import com.atlassian.crucible.wikirenderer.macro.ChangesetLinkMacro;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class ChangesetLinkMacroTest {
    private static final String SITE_URL = "http://test/foo";
    private static final String LINKED_OUTPUT = "<span class='cslinkspan'><a href='http://test/foo/changelog/REP-x?cs=abc123'>abc123<input type='hidden' value='abc123' class='csid'><input type='hidden' value='REP-x' class='repname'></a></span>";
    private static final String NONLINKED_OUTPUT = "abc123";
    private RootConfig oldRootConfig;

    @Before
    public void setUp() {
        this.oldRootConfig = AppConfig.getsConfig();
        RootConfig rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
        Mockito.when((Object)rootConfig.getSiteURL()).thenReturn((Object)SITE_URL);
        AppConfig.resetConfig((RootConfig)rootConfig);
    }

    @After
    public void tearDown() {
        AppConfig.resetConfig((RootConfig)this.oldRootConfig);
    }

    @Test
    public void testLinkRendering() throws MacroException {
        ChangesetLinkMacro macro = new ChangesetLinkMacro(true);
        String value = this.pumpMacro(macro);
        Assert.assertEquals((String)"Macro expansion failed", (Object)LINKED_OUTPUT, (Object)value);
    }

    @Test
    public void testNonLinkRendering() throws MacroException {
        ChangesetLinkMacro macro = new ChangesetLinkMacro(false);
        String value = this.pumpMacro(macro);
        Assert.assertEquals((String)"Macro expansion failed", (Object)NONLINKED_OUTPUT, (Object)value);
    }

    private String pumpMacro(ChangesetLinkMacro macro) throws MacroException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", NONLINKED_OUTPUT);
        params.put("rep", "REP-x");
        RenderContext context = new RenderContext();
        context.setBaseUrl("http://test/fisheye");
        context.setSiteRoot("/fisheye");
        return macro.execute(params, null, context);
    }
}

