/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.wikirenderer;

import com.atlassian.crucible.wikirenderer.FishEyeUserLink;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.GenericLinkParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FishEyeUserLinkTest {
    @Mock
    private RenderContext renderContext;

    @Before
    public void setUp() {
        Mockito.when((Object)this.renderContext.getBaseUrl()).thenReturn((Object)"/trolololo");
    }

    private FecruUser createUser(String userName, String displayName) {
        FecruUser fecruUser = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)fecruUser.getUsername()).thenReturn((Object)userName);
        Mockito.when((Object)fecruUser.getDisplayName()).thenReturn((Object)displayName);
        return fecruUser;
    }

    private FishEyeUserLink createUserLink(String userName, String userDisplayName) {
        GenericLinkParser parser = (GenericLinkParser)Mockito.mock(GenericLinkParser.class);
        Mockito.when((Object)parser.getNotLinkBody()).thenReturn((Object)("~" + userName));
        return new FishEyeUserLink(this.renderContext, parser, this.createUser(userName, userDisplayName));
    }

    @Test
    public void testLinkBodyShouldBeAnUserDisplayName() {
        FishEyeUserLink userLink = this.createUserLink("ironman", "IronMan");
        Assert.assertThat((Object)userLink.getLinkBody(), (Matcher)Matchers.equalTo((Object)"IronMan"));
    }

    @Test
    public void testLinkBodyShouldEscapeWikiSpecialCharacters() {
        FishEyeUserLink userLinkWithAsterisk = this.createUserLink("ironman", "IronMan *The master*");
        FishEyeUserLink userLinkWithHyphens = this.createUserLink("i9", "i9 -wise-");
        Assert.assertThat((Object)userLinkWithAsterisk.getLinkBody(), (Matcher)Matchers.equalTo((Object)"IronMan \\*The master\\*"));
        Assert.assertThat((Object)userLinkWithHyphens.getLinkBody(), (Matcher)Matchers.equalTo((Object)"i9 \\-wise\\-"));
    }
}

