/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.wikirenderer;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.crucible.wikirenderer.CrucibleWikiRenderer;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.web.NavBuilder;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.ConfigMockery;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.syntax.DefaultLinkerService;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.user.UserManager;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public final class CrucibleWikiRendererTest {
    private CrucibleWikiRenderer renderer;
    private final RootConfig rootConfig = ConfigMockery.mockRootConfig();
    private final String buildStamp = FisheyeVersionInfo.BUILD_STAMP;
    private RootConfig oldConfig;
    private UserManager userManager = (UserManager)Mockito.mock(UserManager.class);

    @Before
    public void setUp() throws Exception {
        this.oldConfig = AppConfig.getsConfig();
        AppConfig.resetConfig((RootConfig)this.rootConfig);
        RendererConfiguration configuration = new RendererConfiguration(){

            public String getWebAppContextPath() {
                return CrucibleWikiRendererTest.this.rootConfig.getContextPath();
            }

            public boolean isNofollowExternalLinks() {
                return false;
            }

            public boolean isAllowCamelCase() {
                return false;
            }

            public String getCharacterEncoding() {
                return "UTF-8";
            }
        };
        DefaultLinkerService defaultLinkerService = ConfigMockery.createJIRALinkerService();
        this.renderer = new CrucibleWikiRenderer(configuration, this.rootConfig, (LinkerService)defaultLinkerService, this.userManager);
    }

    @After
    public void tearDown() {
        AppConfig.resetConfig((RootConfig)this.oldConfig);
    }

    @Test
    public void testRenderWikiText() {
        this.assertText("<p><b>bold</b></p>", "*bold*");
        this.assertText("<p><b>bold</b> &amp;nbsp; <em>emphasis</em></p>", "*bold* &nbsp; _emphasis_");
        this.assertText("<p><em>emphasis</em></p>", "_emphasis_");
        this.assertText("<p>&amp;copy; <em>emphasis</em></p>", "&copy; _emphasis_");
        this.assertText("<h1><a name=\"heading\"></a>heading</h1>", "h1. heading");
        this.assertText("<ul><li>list</li></ul>", " * list");
        this.assertText("<div class=\"preformatted panel\" style=\"border-width: 1px;\"><div class=\"preformattedContent panelContent\"><pre>*bold*</pre></div></div>", "{noformat}*bold*{noformat}");
        this.assertText("<p><span class=\"image-wrap\" style=\"\"><img src=\"http://skitch.com/picture.jpg\" style=\"border: 0px solid black\" /></span></p>", "!http://skitch.com/picture.jpg!");
        this.assertText("<div class=\"code panel\" style=\"border-width: 1px;\"><div class=\"codeContent panelContent\"><div class=\"error\"><span class=\"error\">Unable to find source-code formatter for language: x&quot;&lt;/pre&gt;&lt;script&gt;alert(1)&lt;/script&gt;.</span> Available languages are: actionscript, html, java, javascript, none, sql, xhtml, xml</div><pre>xxx</pre></div></div>", "{code:lang=x\"</pre><script>alert(1)</script>}xxx{code}");
        this.assertText("<p><span class='cslinkspan'><a href='" + NavBuilder.changesetAbs(null, (String)"fish", (String)"1234") + "'>1234<input type='hidden' value='1234' class='csid'><input type='hidden' value='fish' class='repname'></a></span></p>", "{cs:id=1234|rep=fish}");
        this.assertText("<p><span class='cslinkspan'><a href='" + NavBuilder.changesetAbs(null, (String)"fish", (String)"<>&") + "'>&lt;&gt;&amp;<input type='hidden' value='\\u003c\\u003e&' class='csid'><input type='hidden' value='fish' class='repname'></a></span></p>", "{cs:id=<>& |rep=fish}");
        this.assertText("<p><span class='cslinkspan'><a href='" + NavBuilder.changesetAbs(null, (String)"fish", (String)"1234") + "'>testname<input type='hidden' value='1234' class='csid'><input type='hidden' value='fish' class='repname'></a></span></p>", "{cs:id=1234|rep=fish|title=testname}");
        this.assertText("<p><span class='cslinkspan'><a href='" + NavBuilder.changesetAbs(null, (String)"fish", (String)"1234") + "'>&lt;a href=&quot;javascript:alert(&#39;pwned&#39;);&quot;&gt;test&lt;/a&gt;<input type='hidden' value='1234' class='csid'><input type='hidden' value='fish' class='repname'></a></span></p>", "{cs:id=1234|rep=fish|title=<a href=\"javascript:alert('pwned');\">test</a>}");
        this.assertText("<p> <br> <br> <br> <br>text1 text1 text1  <br> <br> <br>text2</p>", "\n\r\n\r\n\rtext1 text1 text1 \n\n\ntext2\n");
        this.assertText("<p><p>text1 text1 text1 <p>text2</p>", "\n\r\n\r\n\rtext1 text1 text1 \n\n\ntext2\n", this.renderer.setupRenderContextProperties((RenderContext)new CrucibleRenderContext(null, " ", "<p>", null, null, false)));
        this.assertText("<p><p><p><p><p>text1 text1 text1 <p><p><p>text2</p>", "\n\r\n\r\n\rtext1 text1 text1 \n\n\ntext2\n", this.renderer.setupRenderContextProperties((RenderContext)new CrucibleRenderContext(null, " ", "<p>", null, null, true)));
        this.assertText("<p><a href=\"http://www.google.com\">http://www.google.com</a></p>", "http://www.google.com");
        this.assertText("<p><img class=\"emoticon\" src=\"" + this.rootConfig.getSiteURL() + "/static/" + this.buildStamp + "/2static/images/wiki/icons/emoticons/smile.gif\" height=\"20\" width=\"20\" align=\"absmiddle\" alt=\"\" border=\"0\"/></p>", ":)");
        this.assertText("<p><a href=\"http://www.google.com\">link name</a></p>", "[link name|http://www.google.com]");
        this.assertText("<p><a href=\"http://www.google.com/\">link name</a></p>", "[link name|http://www.google.com/]");
        this.assertText("<p><a href=\"http://www.google.com\">http://www.google.com</a></p>", "[http://www.google.com]");
        this.assertText("<p><a href=\"http://www.google.com/\">http://www.google.com/</a></p>", "[http://www.google.com/]");
        this.assertText("<p><a href=\"http://www.google.com/\">link http://www.google.com name</a></p>", "[link http://www.google.com name|http://www.google.com/]");
        this.assertText("<p><a href=\"http://www.google.com\">link  name</a></p>", "[link  name|http://www.google.com]");
        this.assertText("<p><a href=\"http://www.google.com\">link name   </a></p>", "[link name   |http://www.google.com]");
        this.assertText("<p><a href=\"http://www.google.com\">" + HtmlEscaper.escapeAll((String)"<a href=\"#fakelink?&\"></a>", (boolean)true) + "</a></p>", "[<a href=\"#fakelink?&\"></a>|http://www.google.com]");
        this.assertText("<p><a href=\"http://www.google.com\">link name</a></p>", "[link name| http://www.google.com ]");
        this.assertText("<p><a href=\"http://www.google.com\">link name</a></p>", "[link name|  http://www.google.com]");
        this.assertText("<p><a href=\"http://www.google.com\">link name</a></p>", "[link name|http://www.google.com  ]");
        this.assertText("<p><a href=\"http://skitch.com/picture.jpg\"><span class=\"image-wrap\" style=\"\"><img src=\"http://skitch.com/picture.jpg\" style=\"border: 0px solid black\" /></span></a></p>", "[!http://skitch.com/picture.jpg!|http://skitch.com/picture.jpg]");
        this.assertPreserved("*bold*");
        this.assertPreserved("_emphasis_");
        this.assertPreserved("h1. heading");
        this.assertPreserved(" * list");
        this.assertPreserved("{noformat}*bold*{noformat}");
        this.assertPreserved("{cs:id=1234|rep=fish}");
        this.assertPreserved(":)");
        this.assertText("<p>{cs:id=&lt;&gt;&amp; |rep=fish}</p>", "{preserve-old}{cs:id=<>& |rep=fish}{preserve-old}");
        this.assertText("<p>{cs:id=1234|rep=fish|title=&lt;a href=&quot;javascript:alert(&#39;pwned&#39;);&quot;&gt;test&lt;/a&gt;}</p>", "{preserve-old}{cs:id=1234|rep=fish|title=<a href=\"javascript:alert('pwned');\">test</a>}{preserve-old}");
        this.assertText("<p>!<a href=\"http://skitch.com/picture.jpg!\">http://skitch.com/picture.jpg!</a></p>", "{preserve-old}!http://skitch.com/picture.jpg!{preserve-old}");
        this.assertTextPlain("*bold*", "bold");
        this.assertTextPlain("_emphasis_", "emphasis");
        this.assertTextPlain("h1. heading", "heading");
        this.assertTextPlain("foo\n* list\n* list2\n", "foo\n\n\n*list\n*list2");
        this.assertTextPlain("{noformat}*bold*{noformat}", "*bold*");
        this.assertTextPlain("{cs:id=1234|rep=fish}", "1234");
        this.assertTextPlain("{cs:id=1234|rep=fish|title=testname}", "testname");
        this.assertText("<p><tt>i += 1</tt></p>", "{{i += 1}}");
        this.assertText("<p><tt>i &#43;= 1</tt></p>", "{{i \\+= 1}}");
        this.assertText("<div class='table-wrap'><table class='confluenceTable'><tbody><tr><th class='confluenceTh'>" + HtmlEscaper.escapeAll((String)"<a href='test'>test</a>", (boolean)true) + "</th></tr></tbody></table></div>", "||<a href='test'>test</a>||");
        this.assertText("<p>a <a href=\"http://www.google.com\">http://www.google.com</a> a <a href=\"http://www.google.com\">http://www.google.com</a></p>", "a http://www.google.com a http://www.google.com");
        this.assertText("<div class='table-wrap'><table class='confluenceTable'><tbody><tr><th class='confluenceTh'><span class=\"jira-hover-trigger\"><a href=\"http://fake/jira/browse/JRA-123\">JRA-123</a></span></th></tr></tbody></table></div>", "||JRA-123||");
        this.assertText("<p><span class=\"jira-hover-trigger\"><a href=\"http://fake/jira/browse/JRA-123\">JRA-123</a></span></p>", "[JRA-123]");
        this.assertText("<p><span class=\"jira-hover-trigger\"><a href=\"http://fake/jira/browse/JRA-123\">A jira</a></span></p>", "[A jira|JRA-123]");
    }

    @Test
    public void testRenderValidUserLink() {
        FecruUser user = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)user.getUsername()).thenReturn((Object)"fred");
        Mockito.when((Object)user.getDisplayName()).thenReturn((Object)"Fred Nurk");
        this.userLinkTest(user, "<p><a href=\"http://localhost/user/fred\" class=\"user userorcommitter\" data-username=\"fred\">Fred Nurk</a></p>");
    }

    @Test
    public void testRenderInvalidUserLink() {
        this.userLinkTest(null, "<p><span class=\"error\">&#91;~fred&#93;</span></p>");
    }

    private void userLinkTest(FecruUser userToReturn, String textToExpect) {
        Mockito.when((Object)this.userManager.getLicensedUser("fred")).thenReturn((Object)userToReturn);
        this.assertText(textToExpect, "[~fred]");
    }

    private void assertPreserved(String wikiText) {
        this.assertText("<p>" + wikiText + "</p>", "{preserve-old}" + wikiText + "{preserve-old}");
    }

    private void assertTextPlain(String wikiText, String expected) {
        RenderContext rc = new RenderContext();
        rc.setBaseUrl(this.rootConfig.getSiteURL());
        Assert.assertEquals((String)"wrong text", (String)expected, (String)this.renderer.renderPlain((CharSequence)wikiText, rc));
    }

    private void assertText(String htmlExpected, String wikiText) {
        this.assertText(htmlExpected, wikiText, this.renderer.setupRenderContextProperties(new RenderContext()));
    }

    private void assertText(String htmlExpected, String wikiText, RenderContext rc) {
        rc.setBaseUrl(this.rootConfig.getSiteURL());
        rc.setImagePath(this.rootConfig.getSiteURL() + "/static/" + this.buildStamp + "/2static/images/wiki");
        Assert.assertEquals((String)("wrong html for input [" + wikiText + "]"), (String)htmlExpected, (String)this.renderer.render((CharSequence)wikiText, rc).replaceAll("\\t|\\n|\\r", ""));
    }
}

