/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.testutil;

import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;

public class MockFileRevisionExtraInfoBuilder {
    private Review review = new Review();
    private Date dateAdded = new Date();
    private boolean showAsDiff = true;
    private final ImmutableList.Builder<FRXRevision> frxRevisions = ImmutableList.builder();

    private MockFileRevisionExtraInfoBuilder() {
    }

    public MockFileRevisionExtraInfoBuilder addFrxRevisions(FRXRevision ... revisions) {
        this.frxRevisions.add((Object[])revisions);
        return this;
    }

    public MockFileRevisionExtraInfoBuilder addFrxRevisions(Iterable<FRXRevision> revisions) {
        this.frxRevisions.addAll(revisions);
        return this;
    }

    public FileRevisionExtraInfo build() {
        FileRevisionExtraInfo frx = new FileRevisionExtraInfo(this.review, this.dateAdded){

            public List<FRXRevision> getFrxRevisions() {
                return this.frxRevisions;
            }
        };
        frx.setFrxRevisions((List)this.frxRevisions.build());
        frx.setShowAsDiff(Boolean.valueOf(this.showAsDiff));
        return frx;
    }

    public MockFileRevisionExtraInfoBuilder showAsDiff(boolean showAsDiff) {
        this.showAsDiff = showAsDiff;
        return this;
    }

    public static MockFileRevisionExtraInfoBuilder newInstance() {
        return new MockFileRevisionExtraInfoBuilder();
    }
}

