/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.stars;

import com.atlassian.fisheye.dbtest.StarValidationTestBase;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.SpringContext;

public class CrucibleStarsValidationTest
extends StarValidationTestBase {
    private Project project;
    private ProjectManager pm;
    private CommentManager commentManager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.pm = (ProjectManager)SpringContext.getComponentByClass(ProjectManager.class);
        this.project = this.pm.createProject("foo", "FOO");
        this.commentManager = ModelUtils.getCommentManager();
    }

    public void testReviewStarValidation() throws Exception {
        HibernateUtil.beginTransaction();
        Review review = this.reviewManager.createReview(this.pm, this.project, "test review1", this.currentCrucibleUser);
        review.setModerator(this.currentCrucibleUser);
        review.setAuthor(this.currentCrucibleUser);
        review.setCreator(this.currentCrucibleUser);
        HibernateUtil.commitTransaction();
        StarKey valid = this.createIntStarKey(StarType.REVIEW, review.getId());
        StarKey invalid = this.createIntStarKey(StarType.REVIEW, review.getId() + 2);
        this.testStar(valid, true);
        this.testStar(invalid, false);
    }

    public void testCommentStarValidation() throws Exception {
        HibernateUtil.beginTransaction();
        Review review = this.reviewManager.createReview(this.pm, this.project, "test review1", this.currentCrucibleUser);
        review.setModerator(this.currentCrucibleUser);
        review.setAuthor(this.currentCrucibleUser);
        review.setCreator(this.currentCrucibleUser);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        Comment comment = this.commentManager.createComment("comment1 on ", review, this.currentCrucibleUser);
        HibernateUtil.commitTransaction();
        StarKey valid = this.createIntStarKey(StarType.COMMENT, comment.getId());
        StarKey invalid = this.createIntStarKey(StarType.COMMENT, comment.getId() + 2);
        this.testStar(valid, true);
        this.testStar(invalid, false);
    }

    public void testProjectStarValidation() throws Exception {
        StarKey valid = this.createIntStarKey(StarType.PROJECT, this.project.getId());
        StarKey invalid = this.createIntStarKey(StarType.PROJECT, this.project.getId() + 1);
        this.testStar(valid, true);
        this.testStar(invalid, false);
    }
}

