/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.services;

import com.atlassian.crucible.spi.data.ProjectData;
import com.atlassian.crucible.spi.services.ProjectSearchCriteria;
import com.atlassian.crucible.spi.services.SearchCriteriaJunctionType;
import com.atlassian.crucible.spi.services.SearchCriteriaType;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectSearchCriteriaTest {
    private ProjectSearchCriteria searchCriteria;
    private ProjectData p1;
    private ProjectData p2;
    private ProjectData p3;
    private ProjectData p4;
    private ProjectData p5;
    private List<ProjectData> list;

    @Before
    public void setUp() throws Exception {
        this.p1 = ProjectData.ProjectDataBuilder.builder().setName("name1").setProjectKey("key1").setDefaultRepositoryName("repo1").setPermissionSchemeName("perm1").build();
        this.p2 = ProjectData.ProjectDataBuilder.builder().setName("name2").setProjectKey("key2").setDefaultRepositoryName("repo2").setPermissionSchemeName("perm2").build();
        this.p3 = ProjectData.ProjectDataBuilder.builder().setName("name3").setProjectKey("key3").setDefaultRepositoryName("repo3").setPermissionSchemeName("perm3").build();
        this.p4 = ProjectData.ProjectDataBuilder.builder().setName("name4").setProjectKey("key4").setDefaultRepositoryName("repo4").setPermissionSchemeName("perm4").build();
        this.p5 = ProjectData.ProjectDataBuilder.builder().setName("name5").setProjectKey("key5").setDefaultRepositoryName("repo5").setPermissionSchemeName("perm5").build();
        this.list = Arrays.asList(this.p1, this.p2, this.p3, this.p4, this.p5);
    }

    @Test
    public void testFilterPredicateAllAnd() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.all();
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicateAllOr() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.all();
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicateNameExactFound() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.name("name1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.p1)));
    }

    @Test
    public void testFilterPredicateNameExactNotFound() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.name("name");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Is.is((Matcher)Matchers.emptyIterable()));
    }

    @Test
    public void testFilterPredicateNamePartialFoundPrefix() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.name("name");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicateNamePartialFoundSuffix() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.name("1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.p1)));
    }

    @Test
    public void testFilterPredicateNamePartialFoundMiddle() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.name("ame");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicateKeyExactFound() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.key("key1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.p1)));
    }

    @Test
    public void testFilterPredicateKeyExactNotFound() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.key("key");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Is.is((Matcher)Matchers.emptyIterable()));
    }

    @Test
    public void testFilterPredicateKeyPartialFoundPrefix() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.key("key");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicateKeyPartialFoundSuffix() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.key("1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.p1)));
    }

    @Test
    public void testFilterPredicateKeyPartialFoundMiddle() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.key("ey");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicateRepoExactFound() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.defaultRepositoryName("repo1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.p1)));
    }

    @Test
    public void testFilterPredicateRepoExactNotFound() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.defaultRepositoryName("repo");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Is.is((Matcher)Matchers.emptyIterable()));
    }

    @Test
    public void testFilterPredicateRepoPartialFoundPrefix() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.defaultRepositoryName("repo");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicateRepoPartialFoundSuffix() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.defaultRepositoryName("1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.p1)));
    }

    @Test
    public void testFilterPredicateRepoPartialFoundMiddle() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.defaultRepositoryName("epo");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicatePermissionSchemeExactFound() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.permissionSchemeName("perm1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.p1)));
    }

    @Test
    public void testFilterPredicatePermissionSchemeExactNotFound() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH);
        this.searchCriteria.permissionSchemeName("perm");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Is.is((Matcher)Matchers.emptyIterable()));
    }

    @Test
    public void testFilterPredicatePermissionSchemePartialFoundPrefix() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.permissionSchemeName("perm");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterPredicatePermissionSchemePartialFoundSuffix() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.permissionSchemeName("1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.p1)));
    }

    @Test
    public void testFilterPredicatePermissionSchemeKeyOrNamePartial() throws Exception {
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.permissionSchemeName("erm");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.p1), Matchers.equalTo((Object)this.p2), Matchers.equalTo((Object)this.p3), Matchers.equalTo((Object)this.p4), Matchers.equalTo((Object)this.p5)}));
    }

    @Test
    public void testFilterProjectNameAndKeyPartialFoundMiddle() throws Exception {
        ProjectData p6 = ProjectData.ProjectDataBuilder.builder().setName("project PROJD").setProjectKey("PROJD").setDefaultRepositoryName("repo6").setPermissionSchemeName("perm6").build();
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.key = "PROJD";
        this.searchCriteria.name = "PROJD";
        Assert.assertThat((Object)Iterables.filter((Iterable)ImmutableList.builder().addAll(this.list).add((Object)p6).build(), (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)p6)));
    }

    @Test
    public void testFilterProjectNameOrKeyPartialFoundMiddle() throws Exception {
        ProjectData p6 = ProjectData.ProjectDataBuilder.builder().setName("project").setProjectKey("PROJD").setDefaultRepositoryName("repo6").setPermissionSchemeName("perm6").build();
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.key = "PROJD";
        this.searchCriteria.name = "PROJD";
        ImmutableList unfiltered = ImmutableList.builder().addAll(this.list).add((Object)p6).build();
        Iterable filtered = Iterables.filter((Iterable)unfiltered, (Predicate)this.searchCriteria.filterPredicate());
        Assert.assertThat((Object)filtered, (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)p6)));
    }

    @Test
    public void testFilterProjectNameAndKeyPartialNotFoundMiddle() throws Exception {
        ProjectData p6 = ProjectData.ProjectDataBuilder.builder().setName("project PROJC").setProjectKey("PROJD").setDefaultRepositoryName("repo6").setPermissionSchemeName("perm6").build();
        this.searchCriteria = ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.AND, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        this.searchCriteria.key = "PROJD";
        this.searchCriteria.name = "PROJD";
        Assert.assertThat((Object)Iterables.filter((Iterable)ImmutableList.builder().addAll(this.list).add((Object)p6).build(), (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Is.is((Matcher)Matchers.emptyIterable()));
    }
}

