/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.services;

import com.atlassian.crucible.spi.data.NamedPrincipalAssociationData;
import com.atlassian.crucible.spi.services.NamedPrincipalAssociationSearchCriteria;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NamedPrincipalAssociationSearchCriteriaTest {
    private NamedPrincipalAssociationSearchCriteria searchCriteria;
    private NamedPrincipalAssociationData pa1;
    private NamedPrincipalAssociationData pa2;
    private NamedPrincipalAssociationData pa3;
    private NamedPrincipalAssociationData pa4;
    private NamedPrincipalAssociationData pa5;
    private List<NamedPrincipalAssociationData> list;

    @Before
    public void setUp() throws Exception {
        this.searchCriteria = NamedPrincipalAssociationSearchCriteria.create();
        this.pa1 = new NamedPrincipalAssociationData();
        this.pa1.setName("pa1");
        this.pa1.setAction("a1");
        this.pa2 = new NamedPrincipalAssociationData();
        this.pa2.setName("pa2");
        this.pa2.setAction("a2");
        this.pa3 = new NamedPrincipalAssociationData();
        this.pa3.setName("pa3");
        this.pa3.setAction("a3");
        this.pa4 = new NamedPrincipalAssociationData();
        this.pa4.setName("pa4");
        this.pa4.setAction("a4");
        this.pa5 = new NamedPrincipalAssociationData();
        this.pa5.setName("pa5");
        this.pa5.setAction("a5");
        this.list = Arrays.asList(this.pa1, this.pa2, this.pa3, this.pa4, this.pa5);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFilterPredicateAll() throws Exception {
        this.searchCriteria.all();
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)this.pa1), Matchers.equalTo((Object)this.pa2), Matchers.equalTo((Object)this.pa3), Matchers.equalTo((Object)this.pa4), Matchers.equalTo((Object)this.pa5)}));
    }

    @Test
    public void testFilterPredicateName1() throws Exception {
        this.searchCriteria.name("pa1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.pa1)));
    }

    @Test
    public void testFilterPredicateName2() throws Exception {
        this.searchCriteria.name("pa2");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.pa2)));
    }

    @Test
    public void testFilterPredicateNameNotFound() throws Exception {
        this.searchCriteria.name("pa-not-found");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Is.is((Matcher)Matchers.emptyIterable()));
    }

    @Test
    public void testFilterPredicateAction1() throws Exception {
        this.searchCriteria.action("a1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.pa1)));
    }

    @Test
    public void testFilterPredicateAction2() throws Exception {
        this.searchCriteria.action("a2");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.pa2)));
    }

    @Test
    public void testFilterPredicateActionNotFound() throws Exception {
        this.searchCriteria.action("a-not-found");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Is.is((Matcher)Matchers.emptyIterable()));
    }

    @Test
    public void testFilterPredicateNameAndActionFound() throws Exception {
        this.searchCriteria.name("pa1");
        this.searchCriteria.action("a1");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)this.pa1)));
    }

    @Test
    public void testFilterPredicateNameAndActionNotFound() throws Exception {
        this.searchCriteria.name("pa1");
        this.searchCriteria.action("a2");
        Assert.assertThat((Object)Iterables.filter(this.list, (Predicate)this.searchCriteria.filterPredicate()), (Matcher)Is.is((Matcher)Matchers.emptyIterable()));
    }
}

