/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.atlassian.crucible.spi.rpc.DatabaseChange;
import com.atlassian.crucible.spi.rpc.DatabaseConditionalGet;
import com.atlassian.crucible.spi.rpc.LastChange;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Test;

public final class DatabaseConditionalGetTest {
    @Test
    public void testHibernateUpdate() throws Exception {
        Runnable[] updatingMethods;
        final DatabaseChange.HibernateUpdateListener listener = new DatabaseChange.HibernateUpdateListener();
        for (Runnable method : updatingMethods = new Runnable[]{new Runnable(){

            @Override
            public void run() {
                listener.onFlushDirty(null, null, null, null, null, null);
            }

            public String toString() {
                return "onFlushDirty";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.onSave(null, null, null, null, null);
            }

            public String toString() {
                return "onSave";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.onDelete(null, null, null, null, null);
            }

            public String toString() {
                return "onDelete";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.onCollectionRecreate(null, null);
            }

            public String toString() {
                return "onCollectionRecreate";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.onCollectionRemove(null, null);
            }

            public String toString() {
                return "onCollectionRemove";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.onCollectionUpdate(null, null);
            }

            public String toString() {
                return "onCollectionUpdate";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.postFlush(null);
            }

            public String toString() {
                return "postFlush";
            }
        }}) {
            this.assertUpdated("last changed should have been updated after calling " + method.toString() + ":", method);
        }
    }

    private void assertUpdated(final String message, Runnable method) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        DatabaseConditionalGet<String> get = new DatabaseConditionalGet<String>(){
            final LastChange.LastChangeTag lastChanged = this.getLastChange();

            public String doGet() {
                Assert.assertNotSame((String)message, (Object)this.lastChanged, (Object)this.getLastChange());
                return "success";
            }
        };
        new Thread(() -> {
            method.run();
            latch.countDown();
        }).start();
        latch.await(3L, TimeUnit.SECONDS);
        get.doGet();
    }

    @Test
    public void testHibernateNoUpdate() throws Exception {
        Runnable[] nonUpdatingMethods;
        final DatabaseChange.HibernateUpdateListener listener = new DatabaseChange.HibernateUpdateListener();
        for (Runnable method : nonUpdatingMethods = new Runnable[]{new Runnable(){

            @Override
            public void run() {
                listener.afterTransactionBegin(null);
            }

            public String toString() {
                return "afterTransactionBegin";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.afterTransactionCommit(null);
            }

            public String toString() {
                return "afterTransactionCommit";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.afterTransactionRollback(null);
            }

            public String toString() {
                return "afterTransactionRollback";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.beforeTransactionCompletion(null);
            }

            public String toString() {
                return "beforeTransactionCompletion";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.onLoad(null, null, null, null, null);
            }

            public String toString() {
                return "onLoad";
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.preFlush(null);
            }

            public String toString() {
                return "preFlush";
            }
        }}) {
            this.assertNotUpdated("last changed should not have been updated after calling " + method.toString() + ":", method);
        }
    }

    private void assertNotUpdated(final String message, Runnable method) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        DatabaseConditionalGet<Void> get = new DatabaseConditionalGet<Void>(){
            private final LastChange.LastChangeTag oldLastChanged = this.getLastChange();

            public Void doGet() {
                Assert.assertSame((String)message, (Object)this.oldLastChanged, (Object)this.getLastChange());
                return null;
            }
        };
        new Thread(() -> {
            method.run();
            latch.countDown();
        }).start();
        latch.await(3L, TimeUnit.SECONDS);
        get.doGet();
    }
}

