/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.impl.DefaultSPIUserUtils;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.model.Project;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultSPIUserUtilsTest {
    @Mock
    private UserManager userManager;
    @Mock
    private GlobalPermissionManager globalPermissionManager;
    @Mock
    private Project project;

    @Test
    public void testGetAllowedReviewersWhenEmpty() {
        Mockito.when((Object)this.project.getAllowedReviewers()).thenReturn(new HashSet());
        Mockito.when((Object)this.globalPermissionManager.getUsersWithPermission(GlobalPermissionType.CRUCIBLE_USER)).thenReturn(Collections.singleton("fred"));
        DefaultSPIUserUtils utils = new DefaultSPIUserUtils(this.userManager, null, this.globalPermissionManager);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)utils.getAllowedReviewers(this.project)));
    }

    @Test
    public void testGetAllowedReviewersWhenNonEmpty() {
        Project p = (Project)Mockito.mock(Project.class);
        this.userManager = (UserManager)Mockito.mock(UserManager.class);
        FecruUser fred = this.mockUser("fred");
        FecruUser jim = this.mockUser("jim");
        Mockito.when((Object)this.globalPermissionManager.hasPermission(fred.getUsername(), GlobalPermissionType.CRUCIBLE_USER)).thenReturn((Object)true);
        Mockito.when((Object)p.getAllowedReviewers()).thenReturn(new HashSet<FecruUser>(Arrays.asList(fred, jim)));
        DefaultSPIUserUtils utils = new DefaultSPIUserUtils(this.userManager, null, this.globalPermissionManager);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)utils.getAllowedReviewers(p)));
    }

    private FecruUser mockUser(String username) {
        FecruUser mock = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)mock.getUsername()).thenReturn((Object)username);
        Mockito.when((Object)mock.isEnabled()).thenReturn((Object)true);
        return mock;
    }
}

