/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.explorers.CrucibleChangeSetsHelperFactory;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CustomFilterData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.impl.DefaultReviewService;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.review.ReviewLockManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.jira.issue.JiraIssueService;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.SnippetManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.util.PatchAnchorHelper;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultReviewServiceTest {
    private DefaultReviewService defaultReviewService;
    private TxTemplate txTemplate;
    @Mock
    private EffectiveUserProvider effectiveUserProviderMock;
    @Mock
    private ProjectManager projectManagerMock;
    @Mock
    private UserManager userManagerMock;
    @Mock
    private UnreadManager unreadManagerMock;
    @Mock
    private SourceFactory sourceFactoryMock;
    @Mock
    private ContentManager contentManagerMock;
    @Mock
    private SnippetManager snippetManagerMock;
    @Mock
    private NotificationManager notificationManagerMock;
    @Mock
    private WikiRenderer rendererMock;
    @Mock
    private SPIUtils spiUtilsMock;
    @Mock
    private SPIUserUtils spiUserUtilsMock;
    @Mock
    private ReviewManager reviewManagerMock;
    @Mock
    private JiraIssueService issueServiceMock;
    @Mock
    private JiraServerService jiraServerServiceMock;
    @Mock
    private CommitterUserMappingManager committerUserMappingManagerMock;
    @Mock
    private CommentManager commentManagerMock;
    @Mock
    private EventPublisher eventPublisherMock;
    @Mock
    private CrucibleChangeSetsHelperFactory crucibleChangeSetsHelperFactoryMock;
    @Mock
    private ReviewLockManager reviewLockManagerMock;
    @Mock
    private LogItemManager logManagerMock;
    @Mock
    private PatchManager patchManager;
    @Mock
    private PatchAnchorHelper patchAnchorHelper;
    @Mock
    private PermissionManager permissionManager;
    @Mock
    private Project project;

    @Before
    public void setUp() throws Exception {
        this.txTemplate = new DummyTxTemplate();
        this.defaultReviewService = new DefaultReviewService(this.txTemplate, this.effectiveUserProviderMock, this.projectManagerMock, this.userManagerMock, this.unreadManagerMock, this.sourceFactoryMock, this.contentManagerMock, this.snippetManagerMock, this.notificationManagerMock, this.rendererMock, this.spiUtilsMock, this.spiUserUtilsMock, this.reviewManagerMock, this.issueServiceMock, this.jiraServerServiceMock, this.committerUserMappingManagerMock, this.commentManagerMock, this.eventPublisherMock, this.crucibleChangeSetsHelperFactoryMock, this.reviewLockManagerMock, this.logManagerMock, this.permissionManager, this.patchManager);
        Mockito.when((Object)this.effectiveUserProviderMock.getEffectiveUser()).thenReturn((Object)new FecruUser("matt"));
    }

    @Test
    public void testGetCustomFilterReviewsWithFromAndToDate() {
        CustomFilterData customFilterData = new CustomFilterData(null, null, null, null, null, null, false, Boolean.valueOf(false), Boolean.valueOf(false), null, 1363863913758L, 1363869913758L);
        this.defaultReviewService.getCustomFilterReviews(customFilterData, false);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ReviewFilterDef.class);
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock)).getMatchingReviews((ReviewFilterDef)argument.capture(), Matchers.anyString());
        MatcherAssert.assertThat((Object)((ReviewFilterDef)argument.getValue()).fromDate, (Matcher)IsEqual.equalTo((Object)1363863913758L));
        MatcherAssert.assertThat((Object)((ReviewFilterDef)argument.getValue()).toDate, (Matcher)IsEqual.equalTo((Object)1363869913758L));
    }

    @Test
    public void testGetCustomFilterReviewsWithFromDateOnly() {
        CustomFilterData customFilterData = new CustomFilterData(null, null, null, null, null, null, false, Boolean.valueOf(false), Boolean.valueOf(false), null, 1363863913758L, 0L);
        this.defaultReviewService.getCustomFilterReviews(customFilterData, false);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ReviewFilterDef.class);
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock)).getMatchingReviews((ReviewFilterDef)argument.capture(), Matchers.anyString());
        MatcherAssert.assertThat((Object)((ReviewFilterDef)argument.getValue()).fromDate, (Matcher)IsEqual.equalTo((Object)1363863913758L));
        MatcherAssert.assertThat((Object)((ReviewFilterDef)argument.getValue()).toDate, (Matcher)IsEqual.equalTo((Object)0L));
    }

    @Test
    public void testGetCustomFilterReviewsWithToDateOnly() {
        CustomFilterData customFilterData = new CustomFilterData(null, null, null, null, null, null, false, Boolean.valueOf(false), Boolean.valueOf(false), null, 0L, 1363869913758L);
        this.defaultReviewService.getCustomFilterReviews(customFilterData, false);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ReviewFilterDef.class);
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock)).getMatchingReviews((ReviewFilterDef)argument.capture(), Matchers.anyString());
        MatcherAssert.assertThat((Object)((ReviewFilterDef)argument.getValue()).fromDate, (Matcher)IsEqual.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)((ReviewFilterDef)argument.getValue()).toDate, (Matcher)IsEqual.equalTo((Object)1363869913758L));
    }

    @Test
    public void testGetCustomFilterReviewsWithNoDate() {
        CustomFilterData customFilterData = new CustomFilterData(null, null, null, null, null, null, false, Boolean.valueOf(false), Boolean.valueOf(false), null, 0L, 0L);
        this.defaultReviewService.getCustomFilterReviews(customFilterData, false);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ReviewFilterDef.class);
        ((ReviewManager)Mockito.verify((Object)this.reviewManagerMock)).getMatchingReviews((ReviewFilterDef)argument.capture(), Matchers.anyString());
        MatcherAssert.assertThat((Object)((ReviewFilterDef)argument.getValue()).fromDate, (Matcher)IsEqual.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)((ReviewFilterDef)argument.getValue()).toDate, (Matcher)IsEqual.equalTo((Object)0L));
    }

    @Test
    public void testRemovePatchFromReview() throws Exception {
        PermId reviewId = new PermId("PPP");
        FileRevisionExtraInfo frx = new FileRevisionExtraInfo();
        Review review = this.createReview(this.project);
        CrucibleRevision rev1 = this.createPatchRevision(frx, review, 12, "12:0:T");
        CrucibleRevision rev2 = this.createPatchRevision(frx, review, 12, "12:0:F");
        PatchSource patchSource = (PatchSource)Mockito.mock(PatchSource.class);
        Patch patch = this.createPatch(review, 12, rev1, rev2);
        this.setRemovePatchExpectations((PermId<ReviewData>)reviewId, review, patchSource, patch);
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction((PermissionScheme)Matchers.any(PermissionScheme.class), (Principal)Matchers.any(Principal.class), (FecruUser)Matchers.any(FecruUser.class), Matchers.anyString(), (Review)Matchers.any(Review.class))).thenReturn((Object)true);
        this.defaultReviewService.removePatchFromReview(reviewId, patch.getId().intValue());
        MatcherAssert.assertThat((Object)patch.isAvailableForAdding(), (Matcher)org.hamcrest.Matchers.is((Object)false));
        ((PatchManager)Mockito.verify((Object)this.patchManager, (VerificationMode)Mockito.times((int)1))).removePatchRevision(patchSource, frx, rev1);
        ((PatchManager)Mockito.verify((Object)this.patchManager, (VerificationMode)Mockito.never())).removePatchRevision(patchSource, frx, rev2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemovePatchFromReview_shouldNotRemoveAlreadyRemovedPatch() throws Exception {
        PermId reviewId = new PermId("PPP");
        Review review = this.createReview(this.project);
        Patch patch = this.createPatch(review, 12, new CrucibleRevision[0]);
        patch.setAvailableForAdding(false);
        this.setRemovePatchExpectations((PermId<ReviewData>)reviewId, review, null, patch);
        this.defaultReviewService.removePatchFromReview(reviewId, patch.getId().intValue());
    }

    @Test(expected=IllegalStateException.class)
    public void testRemovePatchFromReview_shouldThrowOnUnremovableRevision() throws Exception {
        PermId reviewId = new PermId("PPP");
        Review review = this.createReview(this.project);
        FileRevisionExtraInfo frx = new FileRevisionExtraInfo();
        CrucibleRevision rev1 = new CrucibleRevision("PATCH:12", null, "12:0:T", "a", new Date());
        CrucibleRevision rev2 = new CrucibleRevision("PATCH:12", null, "12:0:F", "a", new Date());
        Mockito.when((Object)review.getFRX(rev1)).thenReturn((Object)frx);
        Mockito.when((Object)review.getFRX(rev2)).thenReturn((Object)frx);
        PatchSource patchSource = (PatchSource)Mockito.mock(PatchSource.class);
        Patch patch = this.createPatch(review, 12, rev1, rev2);
        this.setRemovePatchExpectations((PermId<ReviewData>)reviewId, review, patchSource, patch);
        ((PatchManager)Mockito.doThrow((Throwable)new IllegalStateException("Things went wrong")).when((Object)this.patchManager)).removePatchRevision(patchSource, frx, rev1);
        this.defaultReviewService.removePatchFromReview(reviewId, patch.getId().intValue());
    }

    @Test(expected=NotPermittedException.class)
    public void testGetPatches_shouldFailIfUnauthorized() {
        PermId permId = new PermId("1");
        Review review = (Review)Mockito.mock(Review.class);
        Mockito.when((Object)review.getProject()).thenReturn((Object)this.project);
        Mockito.when((Object)review.getPermaId()).thenReturn((Object)permId.getId());
        Mockito.when((Object)this.reviewManagerMock.getReviewByPermaId(Matchers.anyString())).thenReturn((Object)review);
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction((PermissionScheme)Matchers.any(PermissionScheme.class), (Principal)Matchers.any(Principal.class), (FecruUser)Matchers.any(FecruUser.class), (String)Matchers.eq((Object)UserActionManager.ACTION_VIEW), (Review)Matchers.eq((Object)review))).thenReturn((Object)false);
        this.defaultReviewService.getReviewPatches(permId);
    }

    @Test(expected=NotPermittedException.class)
    public void testGetPatches_shouldFailIfUnauthorizedForReview() {
        PermId permId = new PermId("1");
        Review review = (Review)Mockito.mock(Review.class);
        Mockito.when((Object)review.getProject()).thenReturn((Object)this.project);
        Mockito.when((Object)review.getPermaId()).thenReturn((Object)permId.getId());
        Mockito.when((Object)this.reviewManagerMock.getReviewByPermaId(Matchers.anyString())).thenReturn((Object)review);
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction((PermissionScheme)Matchers.any(PermissionScheme.class), (Principal)Matchers.any(Principal.class), (FecruUser)Matchers.any(FecruUser.class), (String)Matchers.eq((Object)UserActionManager.ACTION_VIEW), (Review)Matchers.eq((Object)review))).thenReturn((Object)false);
        this.defaultReviewService.getReviewPatches(permId);
    }

    private void setRemovePatchExpectations(PermId<ReviewData> reviewId, Review review, PatchSource patchSource, Patch patch) {
        Mockito.when((Object)this.permissionManager.canPrincipalDoAction(null, null, null, UserActionManager.ACTION_MOD_FILES, review)).thenReturn((Object)true);
        Mockito.when((Object)this.reviewManagerMock.getReviewByPermaId(reviewId.getId())).thenReturn((Object)review);
        Mockito.when((Object)this.patchManager.getPatchById(patch.getId())).thenReturn((Object)patch);
        Mockito.when((Object)this.sourceFactoryMock.getPatchSource(patch.getId().intValue())).thenReturn((Object)patchSource);
    }

    private Patch createPatch(Review review, int patchId, CrucibleRevision ... revs) {
        Patch patch = new Patch();
        patch.setId(Integer.valueOf(patchId));
        patch.setAvailableForAdding(true);
        patch.setReview(review);
        patch.setFileRevisions((List)Lists.newArrayList((Object[])revs));
        return patch;
    }

    private CrucibleRevision createPatchRevision(FileRevisionExtraInfo frx, Review review, int patchId, String revision) {
        CrucibleRevision rev1 = new CrucibleRevision("PATCH:" + patchId, null, revision, "a", new Date());
        Mockito.when((Object)review.getFRX(rev1)).thenReturn((Object)frx);
        return rev1;
    }

    private Review createReview(Project project) {
        Review review = (Review)Mockito.mock(Review.class);
        Mockito.when((Object)review.getId()).thenReturn((Object)12);
        Mockito.when((Object)review.getProject()).thenReturn((Object)project);
        return review;
    }
}

