/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.scm.SCMModule;
import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.crucible.spi.data.GitRepositoryData;
import com.atlassian.crucible.spi.data.PluginRepositoryData;
import com.atlassian.crucible.spi.data.RepositoryData;
import com.atlassian.crucible.spi.data.RepositoryDataSearchCriteria;
import com.atlassian.crucible.spi.data.SvnRepositoryData;
import com.atlassian.crucible.spi.impl.DefaultRepositoryService;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.scm.SCMModuleManager;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultRepositoryServiceTest {
    private DefaultRepositoryService repositoryService;
    @Mock
    private EffectiveUserProvider effectiveUserProviderMock;
    @Mock
    private SCMModuleManager scmModuleManagerMock;
    @Mock
    private UserManager userManagerMock;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SCMModule scmModuleMock;
    @Mock
    private RepositoryManager repositoryManagerMock;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigDocument.Config configMock;
    @Mock
    private SCMRepository scmRepoDeltaPluginEnabled;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RepositoryEngine repoAlphaGitEnabledEngineMock;
    private RepositoryHandle repoHandleAlphaGitEnabled;
    private RepositoryHandle repoHandleOmegaSvnDisabled;
    private final RepoDataMatcher repoAlphaGitEnabledMatcher = new RepoDataMatcher.Builder().setExpectedType(GitRepositoryData.class).setExpectedName("repoAlphaGitEnabled").setExpectedAvailable(true).setExpectedEnabled(true).build();
    private final RepoDataMatcher repoOmegaSvnDisabledMatcher = new RepoDataMatcher.Builder().setExpectedType(SvnRepositoryData.class).setExpectedName("repoOmegaSvnDisabled").setExpectedAvailable(false).setExpectedEnabled(false).build();
    private final RepoDataMatcher repoDeltaPluginEnabledMatcher = new RepoDataMatcher.Builder().setExpectedType(PluginRepositoryData.class).setExpectedName("repoDeltaPluginEnabled").setExpectedAvailable(true).setExpectedEnabled(true).build();

    @Before
    public void setUp() throws Exception {
        this.repositoryService = new DefaultRepositoryService(this.effectiveUserProviderMock, this.scmModuleManagerMock, this.userManagerMock, this.repositoryManagerMock, this.configMock);
        this.repoHandleAlphaGitEnabled = FisheyeTestUtil.createRepositoryHandleMockBuilder("repoAlphaGitEnabled").setScmType(ScmType.GIT).setEnabled(true).setRunning(true).setRepositoryEngine(this.repoAlphaGitEnabledEngineMock).build();
        this.repoHandleOmegaSvnDisabled = FisheyeTestUtil.createRepositoryHandleMockBuilder("repoOmegaSvnDisabled").setScmType(ScmType.SVN).setEnabled(false).setRunning(false).build();
        Mockito.when((Object)this.scmRepoDeltaPluginEnabled.getName()).thenReturn((Object)"repoDeltaPluginEnabled");
        Mockito.when((Object)this.scmRepoDeltaPluginEnabled.isAvailable((Principal)Matchers.any(Principal.class))).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.repositoryManagerMock.getHandles()).thenReturn((Object)ImmutableList.of((Object)this.repoHandleAlphaGitEnabled, (Object)this.repoHandleOmegaSvnDisabled));
        Mockito.when((Object)this.scmModuleManagerMock.getRepositories()).thenReturn((Object)ImmutableSet.of((Object)this.scmRepoDeltaPluginEnabled));
        Mockito.when((Object)this.scmModuleManagerMock.getModules()).thenReturn((Object)ImmutableList.of((Object)this.scmModuleMock));
        Mockito.when((Object)this.scmModuleMock.getRepositories()).thenReturn((Object)ImmutableList.of((Object)this.scmRepoDeltaPluginEnabled));
        Mockito.when((Object)this.userManagerMock.hasPermissionToAccess((Principal)Matchers.any(Principal.class), (RepositoryHandle)Matchers.any(RepositoryHandle.class))).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.configMock.getSecurity().getAllowAnon()).thenReturn((Object)Boolean.TRUE);
    }

    @Test
    public void testGetRepositories() throws Exception {
        List repositories = this.repositoryService.getRepositories();
        Assert.assertThat((String)"all repositories returned with no criteria", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.repoAlphaGitEnabledMatcher, this.repoOmegaSvnDisabledMatcher, this.repoDeltaPluginEnabledMatcher}));
    }

    @Test
    public void testGetRepositoriesAccessibleOnly() throws Exception {
        Mockito.when((Object)this.userManagerMock.hasPermissionToAccess((Principal)Matchers.any(Principal.class), (RepositoryHandle)Matchers.any(RepositoryHandle.class))).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.configMock.getSecurity().getAllowAnon()).thenReturn((Object)Boolean.TRUE);
        List fishEyeReposNotAvailable = this.repositoryService.getRepositories();
        Assert.assertThat((String)"no fisheye repos returned if not available", (Object)fishEyeReposNotAvailable, (Matcher)org.hamcrest.Matchers.contains((Matcher)this.repoDeltaPluginEnabledMatcher));
        Mockito.when((Object)this.userManagerMock.hasPermissionToAccess((Principal)Matchers.any(Principal.class), (RepositoryHandle)Matchers.any(RepositoryHandle.class))).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.configMock.getSecurity().getAllowAnon()).thenReturn((Object)Boolean.FALSE);
        List scmReposNotAvailable = this.repositoryService.getRepositories();
        Assert.assertThat((String)"no scm repos returned if not available", (Object)scmReposNotAvailable, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.repoAlphaGitEnabledMatcher, this.repoOmegaSvnDisabledMatcher}));
        Mockito.when((Object)this.userManagerMock.hasPermissionToAccess((Principal)Matchers.any(Principal.class), (RepositoryHandle)Matchers.any(RepositoryHandle.class))).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.configMock.getSecurity().getAllowAnon()).thenReturn((Object)Boolean.FALSE);
        List noReposAvailable = this.repositoryService.getRepositories();
        Assert.assertThat((String)"no repos returned if none available", (Object)noReposAvailable, (Matcher)org.hamcrest.Matchers.hasSize((int)0));
    }

    @Test
    public void testGetRepositoriesWithLimit() throws Exception {
        Iterable all = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().build(), PageRequest.create((Integer)0, (Integer)3)).getValues();
        Assert.assertThat((String)"all repositories returned if limit high enough", (Object)all, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.repoAlphaGitEnabledMatcher, this.repoOmegaSvnDisabledMatcher, this.repoDeltaPluginEnabledMatcher}));
        Iterable first2 = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().build(), PageRequest.create((Integer)0, (Integer)2)).getValues();
        Assert.assertThat((String)"only first two repositories returned only", (Object)first2, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.repoAlphaGitEnabledMatcher, this.repoOmegaSvnDisabledMatcher}));
        Iterable justTheFirst = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().build(), PageRequest.create((Integer)0, (Integer)1)).getValues();
        Assert.assertThat((String)"just the first repository returned only", (Object)justTheFirst, (Matcher)org.hamcrest.Matchers.contains((Matcher)this.repoAlphaGitEnabledMatcher));
    }

    @Test
    public void testGetRepositoriesNameFilter() throws Exception {
        Iterable repositories = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().setNameFilter("omega").build(), PageRequest.create((Integer)0, (Integer)10)).getValues();
        Assert.assertThat((String)"repositories of names containing omega case insensitive returned only", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher)this.repoOmegaSvnDisabledMatcher));
    }

    @Test
    public void testGetRepositoriesTypeFilter() throws Exception {
        Iterable repositories = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().setTypeFilter((Set)ImmutableSet.of((Object)"git", (Object)"plugin")).build(), PageRequest.create((Integer)0, (Integer)10)).getValues();
        Assert.assertThat((String)"git and plugin repositories returned only", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.repoAlphaGitEnabledMatcher, this.repoDeltaPluginEnabledMatcher}));
    }

    @Test
    public void testGetRepositoriesEnabledFilter() throws Exception {
        Iterable repositories = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().setEnabledFilter(Boolean.TRUE).build(), PageRequest.create((Integer)0, (Integer)10)).getValues();
        Assert.assertThat((String)"enabled repositories returned only", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.repoAlphaGitEnabledMatcher, this.repoDeltaPluginEnabledMatcher}));
    }

    @Test
    public void testGetRepositoriesRunningFilter() throws Exception {
        Iterable repositories = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().setAvailableFilter(Boolean.TRUE).build(), PageRequest.create((Integer)0, (Integer)10)).getValues();
        Assert.assertThat((String)"started and available repositories only", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.repoAlphaGitEnabledMatcher, this.repoDeltaPluginEnabledMatcher}));
    }

    @Test
    public void testGetRepositoriesMixedFilter() throws Exception {
        Iterable repositories = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().setNameFilter("omega").setTypeFilter((Set)ImmutableSet.of((Object)"svn")).setEnabledFilter(Boolean.FALSE).setAvailableFilter(Boolean.FALSE).build(), PageRequest.create((Integer)0, (Integer)1)).getValues();
        Assert.assertThat((String)"only repo matching criteria returned", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher)this.repoOmegaSvnDisabledMatcher));
    }

    @Test
    public void testGetRepositoriesNoFishEyeRepCriteriaSkipFishEyeSource() throws Exception {
        Iterable repositories = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().setTypeFilter((Set)ImmutableSet.of((Object)"plugin")).build(), PageRequest.create((Integer)0, (Integer)10)).getValues();
        Assert.assertThat((String)"only scm repositories returned", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher)this.repoDeltaPluginEnabledMatcher));
        ((RepositoryManager)Mockito.verify((Object)this.repositoryManagerMock, (VerificationMode)Mockito.never())).getHandles();
        ((SCMModuleManager)Mockito.verify((Object)this.scmModuleManagerMock, (VerificationMode)Mockito.times((int)1))).getRepositories();
    }

    @Test
    public void testGetRepositoriesNoPluginCriteriaSkipScmSource() throws Exception {
        Iterable repositories = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().setTypeFilter((Set)ImmutableSet.of((Object)"svn", (Object)"git")).build(), PageRequest.create((Integer)0, (Integer)10)).getValues();
        Assert.assertThat((String)"only scm repositories returned", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.repoAlphaGitEnabledMatcher, this.repoOmegaSvnDisabledMatcher}));
        ((RepositoryManager)Mockito.verify((Object)this.repositoryManagerMock, (VerificationMode)Mockito.times((int)1))).getHandles();
        ((SCMModuleManager)Mockito.verify((Object)this.scmModuleManagerMock, (VerificationMode)Mockito.never())).getRepositories();
    }

    @Test
    public void testGetRepositoriesLowLimitSkipScmSource() throws Exception {
        Iterable repositories = this.repositoryService.getRepositories(new RepositoryDataSearchCriteria.Builder().setTypeFilter((Set)ImmutableSet.of((Object)"svn", (Object)"git", (Object)"plugin")).build(), PageRequest.create((Integer)0, (Integer)1)).getValues();
        Assert.assertThat((String)"only scm repositories returned", (Object)repositories, (Matcher)org.hamcrest.Matchers.contains((Matcher)this.repoAlphaGitEnabledMatcher));
        ((RepositoryManager)Mockito.verify((Object)this.repositoryManagerMock, (VerificationMode)Mockito.times((int)1))).getHandles();
        ((SCMModuleManager)Mockito.verify((Object)this.scmModuleManagerMock, (VerificationMode)Mockito.never())).getRepositories();
    }

    static class RepoDataMatcher
    extends BaseMatcher<RepositoryData> {
        private final Class<? extends RepositoryData> expectedType;
        private final String expectedName;
        private final boolean expectedEnabled;
        private final boolean expectedRunning;

        private RepoDataMatcher(Class<? extends RepositoryData> expectedType, String expectedName, boolean expectedEnabled, boolean expectedRunning) {
            this.expectedType = expectedType;
            this.expectedName = expectedName;
            this.expectedEnabled = expectedEnabled;
            this.expectedRunning = expectedRunning;
        }

        public boolean matches(Object repo) {
            if (null == repo) {
                return false;
            }
            RepositoryData repoData = (RepositoryData)repo;
            return Objects.equal((Object)this.expectedName, (Object)repoData.getName()) && this.expectedEnabled == repoData.isEnabled() && this.expectedRunning == repoData.isAvailable();
        }

        public void describeTo(Description description) {
            description.appendText("instance of ").appendValue((Object)this.expectedType.getSimpleName()).appendText(" with name ").appendValue((Object)this.expectedName).appendText(", enabled ").appendValue((Object)this.expectedEnabled).appendText(" and available ").appendValue((Object)this.expectedRunning);
        }

        public void describeMismatch(Object item, Description description) {
            description.appendText("was ").appendValue((Object)ToStringBuilder.reflectionToString((Object)item));
        }

        public static class Builder {
            private Class<? extends RepositoryData> expectedType;
            private String expectedName;
            private boolean expectedEnabled;
            private boolean expectedRunning;

            public Builder setExpectedType(Class<? extends RepositoryData> expectedType) {
                this.expectedType = expectedType;
                return this;
            }

            public Builder setExpectedName(String expectedName) {
                this.expectedName = expectedName;
                return this;
            }

            public Builder setExpectedEnabled(boolean expectedEnabled) {
                this.expectedEnabled = expectedEnabled;
                return this;
            }

            public Builder setExpectedAvailable(boolean expectedRunning) {
                this.expectedRunning = expectedRunning;
                return this;
            }

            public RepoDataMatcher build() {
                return new RepoDataMatcher(this.expectedType, this.expectedName, this.expectedEnabled, this.expectedRunning);
            }
        }
    }
}

