/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.data;

import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.UserData;
import java.util.Date;
import junit.framework.TestCase;

public class ReviewDataTest
extends TestCase {
    public void testBuilder() {
        Date createDate = new Date();
        Date closeDate = new Date(createDate.getTime() + 1L);
        Date dueDate = new Date(closeDate.getTime() + 1L);
        UserData author = new UserData("fred", "Fred Flintstone", null);
        UserData moderator = new UserData("wilma", "Wilma Flintstone", null);
        UserData creator = new UserData("barney", "Barney Flintstone", null);
        ReviewData reviewData = new ReviewData.Builder().setCreateDate(createDate).setCloseDate(closeDate).setDueDate(dueDate).setAllowReviewersToJoin(Boolean.valueOf(true)).setProjectKey("PROJ-1").setAuthor(author).setModerator(moderator).setCreator(creator).setDescription("description").setJiraIssueKey("JIRA-1").setMetricsVersion(3).setName("name").setPermaId("permaId").setState(ReviewData.State.Closed).setType(ReviewData.ReviewType.SNIPPET).build();
        ReviewDataTest.assertEquals((Object)creator, (Object)reviewData.getCreator());
        ReviewDataTest.assertEquals((Object)moderator, (Object)reviewData.getModerator());
        ReviewDataTest.assertEquals((Object)author, (Object)reviewData.getAuthor());
        ReviewDataTest.assertEquals((Object)closeDate, (Object)reviewData.getCloseDate());
        ReviewDataTest.assertEquals((Object)createDate, (Object)reviewData.getCreateDate());
        ReviewDataTest.assertEquals((Object)dueDate, (Object)reviewData.getDueDate());
        ReviewDataTest.assertTrue((boolean)reviewData.isAllowReviewersToJoin());
        ReviewDataTest.assertEquals((String)"PROJ-1", (String)reviewData.getProjectKey());
        ReviewDataTest.assertEquals((String)"description", (String)reviewData.getDescription());
        ReviewDataTest.assertEquals((String)"JIRA-1", (String)reviewData.getJiraIssueKey());
        ReviewDataTest.assertEquals((int)3, (int)reviewData.getMetricsVersion());
        ReviewDataTest.assertEquals((String)"name", (String)reviewData.getName());
        ReviewDataTest.assertEquals((String)"permaId", (String)reviewData.getPermaId().getId());
        ReviewDataTest.assertEquals((Object)ReviewData.State.Closed, (Object)reviewData.getState());
        ReviewDataTest.assertEquals((Object)ReviewData.ReviewType.SNIPPET, (Object)reviewData.getType());
    }
}

