/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.xml;

import com.atlassian.crucible.migration.NodeCreator;
import com.atlassian.crucible.migration.xml.StAXStreamWriter;
import com.atlassian.crucible.migration.xml.XmlUtils;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;

public class StAXStreamWriterTest
extends TestCase {
    private static final String NS = "http://www.atlassian.com/fisheye/backup-1";

    public void testSingleElement() throws Exception {
        StringWriter out = new StringWriter();
        StAXStreamWriter writer = new StAXStreamWriter((Writer)out, NS);
        NodeCreator nodeCreator = writer.addRootNode("xml");
        StAXStreamWriterTest.assertNotNull((Object)nodeCreator);
        StAXStreamWriterTest.assertNull((Object)nodeCreator.closeEntity());
        writer.close();
        System.out.println(out.toString());
        StAXStreamWriterTest.assertTrue((boolean)XmlUtils.isDOMEquals("<xml xmlns=\"http://www.atlassian.com/fisheye/backup-1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>", out.toString()));
    }

    public void testAttributes() throws Exception {
        StringWriter out = new StringWriter();
        StAXStreamWriter writer = new StAXStreamWriter((Writer)out, NS);
        NodeCreator nodeCreator = writer.addRootNode("xml");
        nodeCreator.addAttribute("key", "value");
        nodeCreator = nodeCreator.addNode("foo");
        nodeCreator = nodeCreator.setContentAsString("bar");
        nodeCreator = nodeCreator.closeEntity();
        StAXStreamWriterTest.assertNull((Object)nodeCreator.closeEntity());
        writer.close();
        System.out.println(out.toString());
        StAXStreamWriterTest.assertTrue((boolean)XmlUtils.isDOMEquals("<xml xmlns=\"http://www.atlassian.com/fisheye/backup-1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" key='value'><foo>bar</foo></xml>", out.toString()));
    }

    public void testDOMEquals() {
        StAXStreamWriterTest.assertTrue((boolean)XmlUtils.isDOMEquals("<xml/>", "<xml />"));
        StAXStreamWriterTest.assertTrue((boolean)XmlUtils.isDOMEquals("<xml/>", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<xml />\n"));
        StAXStreamWriterTest.assertFalse((boolean)XmlUtils.isDOMEquals("<xml/>", "<xmll />"));
        StAXStreamWriterTest.assertTrue((boolean)XmlUtils.isDOMEquals("<xml>   <node1 key=\"value\">foo</node1>\n</xml>\n", "<xml>   <node1  key='value'>foo</node1>\n</xml>"));
    }
}

