/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.xml;

import com.atlassian.crucible.migration.NodeParser;
import com.atlassian.crucible.migration.ParseException;
import com.atlassian.crucible.migration.xml.StAXStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class StAXStreamReaderTest
extends TestCase {
    public void testSplit() {
        List<String> items = Arrays.asList("    dsf ; sdfdsf; sd sf;dsf ; ".split("(\\s*;\\s*)|\\s+"));
        System.out.println(items.size() + " specified items: " + Arrays.toString(items.toArray()));
    }

    public void testSingleElement() throws Exception {
        String xml = "<xml/>";
        StAXStreamReader streamReader = new StAXStreamReader((Reader)new StringReader("<xml/>"));
        NodeParser nodeParser = streamReader.getRootNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertFalse((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"xml", (String)nodeParser.getName());
        nodeParser = nodeParser.getNextNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertTrue((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"xml", (String)nodeParser.getName());
        StAXStreamReaderTest.assertNull((Object)nodeParser.getNextNode());
    }

    public void testProperties() throws Exception {
        String xml = "<xml key1='value1' key2=''/>";
        StAXStreamReader streamReader = new StAXStreamReader((Reader)new StringReader("<xml key1='value1' key2=''/>"));
        NodeParser nodeParser = streamReader.getRootNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertFalse((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"xml", (String)nodeParser.getName());
        StAXStreamReaderTest.assertEquals((String)"value1", (String)nodeParser.getAttribute("key1"));
        StAXStreamReaderTest.assertEquals((String)"", (String)nodeParser.getAttribute("key2"));
        StAXStreamReaderTest.assertNull((Object)nodeParser.getAttribute("key3"));
        try {
            nodeParser.getRequiredAttribute("key3");
            StAXStreamReaderTest.fail();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testXmlWithAttributes() throws Exception {
        String xml = "<?xml version='1.0' encoding='ISO-8859-1'?><xml>   <table name='1' xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">    <integer>2</integer>\n    <date xsi:nil='true'></date>   </table>\n   <table name='2'/>\n</xml>";
        StAXStreamReader streamReader = new StAXStreamReader((Reader)new StringReader("<?xml version='1.0' encoding='ISO-8859-1'?><xml>   <table name='1' xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">    <integer>2</integer>\n    <date xsi:nil='true'></date>   </table>\n   <table name='2'/>\n</xml>"));
        NodeParser nodeParser = streamReader.getRootNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertFalse((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"xml", (String)nodeParser.getName());
        nodeParser = nodeParser.getNextNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertFalse((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"table", (String)nodeParser.getName());
        StAXStreamReaderTest.assertEquals((String)"1", (String)nodeParser.getAttribute("name"));
        nodeParser = nodeParser.getNextNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertFalse((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"integer", (String)nodeParser.getName());
        StAXStreamReaderTest.assertEquals((String)"2", (String)nodeParser.getContentAsString());
        StAXStreamReaderTest.assertTrue((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"integer", (String)nodeParser.getName());
        nodeParser = nodeParser.getNextNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertFalse((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"date", (String)nodeParser.getName());
        StAXStreamReaderTest.assertNull((Object)nodeParser.getContentAsString());
        StAXStreamReaderTest.assertTrue((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"date", (String)nodeParser.getName());
        nodeParser = nodeParser.getNextNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertTrue((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"table", (String)nodeParser.getName());
        nodeParser = nodeParser.getNextNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertFalse((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"table", (String)nodeParser.getName());
        StAXStreamReaderTest.assertEquals((String)"2", (String)nodeParser.getAttribute("name"));
        nodeParser = nodeParser.getNextNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertTrue((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"table", (String)nodeParser.getName());
        nodeParser = nodeParser.getNextNode();
        StAXStreamReaderTest.assertNotNull((Object)nodeParser);
        StAXStreamReaderTest.assertTrue((boolean)nodeParser.isClosed());
        StAXStreamReaderTest.assertEquals((String)"xml", (String)nodeParser.getName());
        StAXStreamReaderTest.assertNull((Object)nodeParser.getNextNode());
    }
}

