/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.NodeStreamReader;
import com.atlassian.crucible.migration.item.DBImporter;
import com.atlassian.crucible.migration.xml.StAXStreamReader;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DbVersion;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import org.dbunit.Assertion;
import org.dbunit.DBTestCase;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.easymock.EasyMock;

public class HSQLDBImporterTest
extends DBTestCase {
    public HSQLDBImporterTest() {
        System.setProperty("dbunit.driverClass", "org.hsqldb.jdbcDriver");
        System.setProperty("dbunit.connectionUrl", String.format("jdbc:hsqldb:file:%s/output/tmp/migration/sampledb", "/Users/kcichy/src/fecru_d"));
        System.setProperty("dbunit.username", "sa");
        System.setProperty("dbunit.password", "");
    }

    protected IDataSet getDataSet() throws Exception {
        return new XmlDataSet((Reader)new StringReader("<dataset>    <table name=\"TEST_TABLE\"/>\n    <table name=\"SECOND_TABLE\"/>\n    <table name='EMPTY_TABLE'/>\n</dataset>"));
    }

    private IDataSet getExpectedDataSet() throws Exception {
        String xml = "<!DOCTYPE dataset SYSTEM \"dataset.dtd\">\n<dataset>\n    <table name=\"TEST_TABLE\">\n        <column>COL0</column>\n        <column>COL1</column>\n        <column>COL2</column>\n        <row>\n            <value>21</value>\n            <value>Foo Bar</value>\n            <value>" + this.datestr("2008-01-09T11:58:32.331+1100") + "</value>\n" + "        </row>\n" + "        <row>\n" + "            <value>875</value>\n" + "            <null/>\n" + "            <null/>\n" + "        </row>\n" + "    </table>\n" + "    <table name=\"SECOND_TABLE\">\n" + "        <column>COLUMN0</column>\n" + "        <column>COLUMN1</column>\n" + "        <row>\n" + "            <value>-12</value>\n" + "            <value>1</value>\n" + "        </row>\n" + "        <row>\n" + "            <value>10000000000000</value>\n" + "            <value>0</value>\n" + "        </row>\n" + "    </table>\n" + "    <table name='EMPTY_TABLE'>\n" + "        <column>COLUMN0</column>\n" + "        <column>COLUMN1</column>\n" + "    </table>\n" + "</dataset>";
        return new XmlDataSet((Reader)new StringReader(xml));
    }

    private String datestr(String s) throws ISO8601DateHelper.InvalidDateException {
        return new Timestamp(ISO8601DateHelper.parseAsUTC((String)s).getTime()).toString();
    }

    protected DatabaseOperation getSetUpOperation() throws Exception {
        return DatabaseOperation.CLEAN_INSERT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImport() throws Exception {
        String xml = "<backup xmlns=\"http://www.atlassian.com/fisheye/backup-1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" schemaVersion=\"29\">\n  <table name=\"SECOND_TABLE\">\n    <column name=\"COLUMN0\"/>\n    <column name=\"COLUMN1\"/>\n    <row>\n      <integer>-12</integer>\n      <boolean>true</boolean>\n    </row>\n    <row>\n      <integer>10000000000000</integer>\n      <boolean>false</boolean>\n    </row>\n  </table>\n  <table name=\"EMPTY_TABLE\">\n    <column name=\"COLUMN0\"/>\n    <column name=\"COLUMN1\"/>\n  </table>\n  <table name=\"TEST_TABLE\">\n    <column name=\"COL0\"/>\n    <column name=\"COL1\"/>\n    <column name=\"COL2\"/>\n    <row>\n      <integer>21</integer>\n      <escapedString>Foo Bar</escapedString>\n      <timestamp>2008-01-09T00:58:32.331Z</timestamp>\n    </row>\n    <row>\n      <integer>875</integer>\n      <escapedString xsi:nil=\"true\"/>\n      <timestamp xsi:nil=\"true\"/>\n    </row>\n  </table>\n</backup>";
        Connection conn = this.getConnection().getConnection();
        DBInfo dbInfo = (DBInfo)EasyMock.createNiceMock(DBInfo.class);
        EasyMock.expect((Object)dbInfo.state()).andReturn((Object)DBInfo.DBState.STOPPED);
        DBControl control = (DBControl)EasyMock.createNiceMock(DBControl.class);
        EasyMock.expect((Object)control.getType()).andReturn((Object)DBType.HSQL);
        EasyMock.expect((Object)control.getConnection()).andStubReturn((Object)conn);
        EasyMock.expect((Object)control.getInfo()).andReturn((Object)dbInfo);
        control.dropTables();
        control.createTables(29);
        control.addConstraints(29);
        control.upgrade(DbVersion.getDatabaseVersion());
        EasyMock.replay((Object[])new Object[]{dbInfo, control});
        DBImporter importer = new DBImporter();
        try {
            importer.importData((NodeStreamReader)new StAXStreamReader((Reader)new StringReader("<backup xmlns=\"http://www.atlassian.com/fisheye/backup-1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" schemaVersion=\"29\">\n  <table name=\"SECOND_TABLE\">\n    <column name=\"COLUMN0\"/>\n    <column name=\"COLUMN1\"/>\n    <row>\n      <integer>-12</integer>\n      <boolean>true</boolean>\n    </row>\n    <row>\n      <integer>10000000000000</integer>\n      <boolean>false</boolean>\n    </row>\n  </table>\n  <table name=\"EMPTY_TABLE\">\n    <column name=\"COLUMN0\"/>\n    <column name=\"COLUMN1\"/>\n  </table>\n  <table name=\"TEST_TABLE\">\n    <column name=\"COL0\"/>\n    <column name=\"COL1\"/>\n    <column name=\"COL2\"/>\n    <row>\n      <integer>21</integer>\n      <escapedString>Foo Bar</escapedString>\n      <timestamp>2008-01-09T00:58:32.331Z</timestamp>\n    </row>\n    <row>\n      <integer>875</integer>\n      <escapedString xsi:nil=\"true\"/>\n      <timestamp xsi:nil=\"true\"/>\n    </row>\n  </table>\n</backup>")), control);
        }
        finally {
            conn.close();
        }
        IDataSet databaseDataSet = this.getConnection().createDataSet();
        System.out.println(Arrays.toString(this.getExpectedDataSet().getTableNames()));
        Assertion.assertEquals((IDataSet)this.getExpectedDataSet(), (IDataSet)databaseDataSet);
        EasyMock.verify((Object[])new Object[]{dbInfo, control});
    }
}

