/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.NodeStreamWriter;
import com.atlassian.crucible.migration.PrintStreamProgressMonitor;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.item.DBExporter;
import com.atlassian.crucible.migration.xml.StAXStreamWriter;
import com.atlassian.crucible.migration.xml.XmlUtils;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DbVersion;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.dbunit.DBTestCase;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;

public class HSQLDBExporterTest
extends DBTestCase {
    private static final String FE_NS = "http://www.atlassian.com/fisheye/backup-1";
    private Date date = new Date();
    private DateFormat hsqldbFormatter;
    private DateFormat xmlFormatter;

    public HSQLDBExporterTest() {
        System.setProperty("dbunit.driverClass", DBType.HSQL.getDriver());
        System.setProperty("dbunit.connectionUrl", String.format("jdbc:hsqldb:file:%s/output/tmp/migration/sampledb", "/Users/kcichy/src/fecru_d"));
        System.setProperty("dbunit.username", "sa");
        System.setProperty("dbunit.password", "");
        this.xmlFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.xmlFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.hsqldbFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    protected DatabaseOperation getSetUpOperation() throws Exception {
        return DatabaseOperation.CLEAN_INSERT;
    }

    protected void setUp() throws Exception {
        this.date = new Date();
        super.setUp();
    }

    protected IDataSet getDataSet() throws Exception {
        String xml = "<!DOCTYPE dataset SYSTEM \"dataset.dtd\">\n<dataset>\n    <table name=\"TEST_TABLE\">\n        <column>COL0</column>\n        <column>COL1</column>\n        <column>COL2</column>\n        <row>\n            <value>21</value>\n            <value>Foo Bar</value>\n            <value>" + this.hsqldbFormatter.format(this.date) + "</value>\n" + "        </row>\n" + "        <row>\n" + "            <value>875</value>\n" + "            <null/>\n" + "            <null/>\n" + "        </row>\n" + "    </table>\n" + "    <table name=\"SECOND_TABLE\">\n" + "        <column>COLUMN0</column>\n" + "        <column>COLUMN1</column>\n" + "        <row>\n" + "            <value>-12</value>\n" + "            <value>1</value>\n" + "        </row>\n" + "        <row>\n" + "            <value>10000000000000</value>\n" + "            <value>0</value>\n" + "        </row>\n" + "    </table>\n" + "    <table name='EMPTY_TABLE'>\n" + "        <column>COLUMN0</column>\n" + "        <column>COLUMN1</column>\n" + "    </table>\n" + "</dataset>";
        return new XmlDataSet((Reader)new StringReader(xml));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExport() throws Exception {
        String expected = "<?xml version='1.0' encoding='ISO-8859-1'?><backup xmlns=\"http://www.atlassian.com/fisheye/backup-1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" schemaVersion=\"" + String.valueOf(DbVersion.getDatabaseVersion()) + "\">" + "<table name=\"test_table\"><column name=\"col0\" /><column name=\"col1\" /><column name=\"col2\" />" + "<row><integer>21</integer><escapedString>Foo Bar</escapedString><timestamp>" + this.xmlFormatter.format(this.date) + "</timestamp></row>" + "<row><integer>875</integer><escapedString xsi:nil=\"true\" /><timestamp xsi:nil=\"true\" /></row></table></backup>";
        StringWriter sink = new StringWriter();
        StAXStreamWriter writer = new StAXStreamWriter((Writer)sink, FE_NS);
        DBExporter exporter = new DBExporter(tableName -> tableName.equals("TEST_TABLE"), (ProgressMonitor)new PrintStreamProgressMonitor(System.out));
        try (Connection conn = this.getConnection().getConnection();){
            exporter.exportData(DBType.HSQL, conn, (NodeStreamWriter)writer);
            writer.close();
        }
        System.out.println(sink.toString());
        System.out.println(expected);
        HSQLDBExporterTest.assertTrue((boolean)XmlUtils.isDOMEquals(expected, sink.toString()));
        expected = "<?xml version='1.0' encoding='ISO-8859-1'?><backup xmlns=\"http://www.atlassian.com/fisheye/backup-1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" schemaVersion=\"" + String.valueOf(DbVersion.getDatabaseVersion()) + "\">" + "<table name=\"second_table\"><column name=\"column0\" /><column name=\"column1\" /><row><integer>-12</integer><boolean>true</boolean></row><row><integer>10000000000000</integer><boolean>false</boolean></row></table></backup>";
        sink = new StringWriter();
        StAXStreamWriter streamWriter = new StAXStreamWriter((Writer)sink, FE_NS);
        exporter = new DBExporter(tableName -> tableName.equals("SECOND_TABLE"), (ProgressMonitor)new PrintStreamProgressMonitor(System.out));
        conn = this.getConnection().getConnection();
        try {
            exporter.exportData(DBType.HSQL, conn, (NodeStreamWriter)streamWriter);
            streamWriter.close();
        }
        finally {
            conn.close();
        }
        System.out.println(sink.toString());
        HSQLDBExporterTest.assertTrue((boolean)XmlUtils.isDOMEquals(expected, sink.toString()));
    }
}

