/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.migration.item;

import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.item.FishEyeCacheBackup;
import com.atlassian.fecru.matcher.FileMatchers;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class FishEyeCacheBackupTest {
    private FishEyeCacheBackup fecb;
    private File baseDir;
    private ZipFile zipFile;
    private ProgressMonitor monitorMock;
    private RepositoryManager repoManagerMock;
    private CrossRepLuceneIndex crossRepLuceneIndexMock;
    private File expFileCacheAlienFile;
    private File expFileCacheCachePluginsSOPFile2;
    private File expFileCacheCachePluginsOsgiCacheFile3;
    private File expFileCacheVarCacheDirRepoXFile4;
    private File expFileAoFile5;
    private File expCrossRepoMetadataIndexFile;
    private File expQuickNavIndexDir;
    private File expPerRepoMetadataIndexDir;
    private File expPerRepoContentIndexFile;
    private File expPerRepoDiffIndexFile;
    private File appConfigInstanceHomeOrig;

    @Before
    public void setUp() throws Exception {
        this.fecb = new FishEyeCacheBackup();
        this.baseDir = FisheyeTestUtil.createTempDir("FishEyeCacheBackupTest");
        this.appConfigInstanceHomeOrig = AppConfig.getInstanceDir();
        File f = new File(this.baseDir, "test.zip");
        this.zipFile = new ZipFileBuilder(f).addFolder("cache/").addFile("cache/alienFile").addFolder("cache/cache/").addFolder("cache/cache/globalfe/").addFolder("cache/cache/globalfe/idx0/").addFile("cache/cache/globalfe/idx0/crossRepoMetadataIndex.txt").addFolder("cache/cache/globalfe/idx1/").addFile("cache/cache/globalfe/idx1/quickNavIndex.txt").addFolder("cache/cache/plugins/").addFolder("cache/cache/plugins/someOtherPlugin/").addFile("cache/cache/plugins/someOtherPlugin/file2").addFolder("cache/cache/plugins/osgi-cache/").addFile("cache/cache/plugins/osgi-cache/file3").addFolder("cache/var/").addFolder("cache/var/cache/").addFolder("cache/var/cache/repoX/").addFile("cache/var/cache/repoX/file4").addFolder("cache/var/cache/repoX/idx0/").addFile("cache/var/cache/repoX/idx0/perRepoMetadataIndex.txt").addFolder("cache/var/cache/repoX/idx1/").addFile("cache/var/cache/repoX/idx1/perRepoContentIndex.txt").addFolder("cache/var/cache/repoX/idx2/").addFile("cache/var/cache/repoX/idx2/perRepoDiffIndex.txt").addFolder("ao/").addFile("ao/file5").build();
        this.expFileCacheAlienFile = new File(this.baseDir, "alienFile");
        this.expFileCacheCachePluginsSOPFile2 = new File(this.baseDir, "cache/plugins/someOtherPlugin/file2");
        this.expFileCacheCachePluginsOsgiCacheFile3 = new File(this.baseDir, "cache/plugins/osgi-cache/file3");
        this.expFileCacheVarCacheDirRepoXFile4 = new File(this.baseDir, "var/cache/repoX/file4");
        this.expFileAoFile5 = new File(this.baseDir, "ao/file5");
        this.expCrossRepoMetadataIndexFile = new File(this.baseDir, "cache/globalfe/idx0/crossRepoMetadataIndex.txt");
        this.expQuickNavIndexDir = new File(this.baseDir, "cache/globalfe/idx1");
        this.expPerRepoMetadataIndexDir = new File(this.baseDir, "var/cache/repoX/idx0");
        this.expPerRepoContentIndexFile = new File(this.baseDir, "var/cache/repoX/idx1/perRepoContentIndex.txt");
        this.expPerRepoDiffIndexFile = new File(this.baseDir, "var/cache/repoX/idx2/perRepoDiffIndex.txt");
        Assert.assertThat((String)"file should not exist prior to test", (Object)this.expFileCacheAlienFile, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to test", (Object)this.expFileCacheCachePluginsSOPFile2, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to test", (Object)this.expFileCacheCachePluginsOsgiCacheFile3, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to test", (Object)this.expFileCacheVarCacheDirRepoXFile4, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to test", (Object)this.expFileAoFile5, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to test", (Object)this.expCrossRepoMetadataIndexFile, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"dir should not exist prior to test", (Object)this.expQuickNavIndexDir, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"dir should not exist prior to test", (Object)this.expPerRepoMetadataIndexDir, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to test", (Object)this.expPerRepoContentIndexFile, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"file should not exist prior to test", (Object)this.expPerRepoDiffIndexFile, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        this.monitorMock = (ProgressMonitor)Mockito.mock(ProgressMonitor.class);
        this.repoManagerMock = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        this.crossRepLuceneIndexMock = (CrossRepLuceneIndex)Mockito.mock(CrossRepLuceneIndex.class);
    }

    @After
    public void tearDown() throws Exception {
        AppConfig.overrideAppHome((File)AppConfig.getAppHome(), (File)this.appConfigInstanceHomeOrig);
        FisheyeTestUtil.deleteDir(this.baseDir);
    }

    @Test
    public void testGetName() throws Exception {
        Assert.assertThat((Object)this.fecb.getName(), (Matcher)CoreMatchers.is((Object)"cache"));
    }

    @Test
    public void testGetRestorerRestore() throws Exception {
        AppConfig.overrideAppHome((File)AppConfig.getAppHome(), (File)this.baseDir);
        Map properties = null;
        Restorer restorer = this.fecb.getRestorer(this.zipFile, this.monitorMock, properties);
        Assert.assertThat((Object)restorer, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        restorer.restore();
        Assert.assertThat((String)"alien cache file should not be restored", (Object)this.expFileCacheAlienFile, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"cache of non osgi-cache plugins should be restored", (Object)this.expFileCacheCachePluginsSOPFile2, FileMatchers.exists());
        Assert.assertThat((String)"osgi-cache files should be ignored", (Object)this.expFileCacheCachePluginsOsgiCacheFile3, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"cache/var/cache files should be restored", (Object)this.expFileCacheVarCacheDirRepoXFile4, FileMatchers.exists());
        Assert.assertThat((String)"non cache files should be ignored", (Object)this.expFileAoFile5, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"cross repo metadata index should be restored", (Object)this.expCrossRepoMetadataIndexFile, FileMatchers.exists());
        Assert.assertThat((String)"obsolete quick nav index should be ignored", (Object)this.expQuickNavIndexDir, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"obsolete per repo metadata index should be ignored", (Object)this.expPerRepoMetadataIndexDir, (Matcher)CoreMatchers.not(FileMatchers.exists()));
        Assert.assertThat((String)"per repo content index should be restored", (Object)this.expPerRepoContentIndexFile, FileMatchers.exists());
        Assert.assertThat((String)"per repo diff index should be restored", (Object)this.expPerRepoDiffIndexFile, FileMatchers.exists());
    }

    @Test
    public void testSaverImplBackup() throws Exception {
        File fishEyeInst = new File(this.baseDir, "extract");
        this.unpack(this.zipFile, new Path((CharSequence)"cache/"), fishEyeInst);
        File outArchiveFile = new File(this.baseDir, "backup.zip");
        IOHelper.mkdirs((File)outArchiveFile.getParentFile());
        IOHelper.createNewFile((File)outArchiveFile);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outArchiveFile));
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new BufferedOutputStream(outStream));
        Mockito.when((Object)this.repoManagerMock.getHandles()).thenReturn(Collections.emptyList());
        AppConfig.overrideAppHome((File)AppConfig.getAppHome(), (File)fishEyeInst);
        FishEyeCacheBackup.SaverImpl saver = new FishEyeCacheBackup.SaverImpl(this.repoManagerMock, this.crossRepLuceneIndexMock);
        saver.setBackupItem((BackupItem)this.fecb);
        saver.backup(zipOutputStream, this.monitorMock, null);
        zipOutputStream.close();
        outStream.close();
        ZipFile outZipFile = new ZipFile(outArchiveFile);
        ArrayList allZipEntries = Lists.newArrayList((Iterator)Iterators.transform((Iterator)Iterators.forEnumeration((Enumeration)outZipFile.entries()), (Function)new Function<ZipEntry, String>(){

            public String apply(ZipEntry zipEntry) {
                Preconditions.checkNotNull((Object)zipEntry);
                return zipEntry.getName();
            }
        }));
        Assert.assertThat((String)"only expected files included in the backup, obstacle indexes and alien files excluded", (Object)allZipEntries, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"cache/cache/globalfe/idx0/crossRepoMetadataIndex.txt", "cache/cache/plugins/osgi-cache/file3", "cache/cache/plugins/someOtherPlugin/file2", "cache/var/cache/repoX/file4", "cache/var/cache/repoX/idx1/perRepoContentIndex.txt", "cache/var/cache/repoX/idx2/perRepoDiffIndex.txt"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpack(ZipFile zip, Path zipPath, File destPath) throws IOException {
        if (!destPath.exists()) {
            destPath.mkdirs();
        }
        Enumeration enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)enumeration.nextElement();
            Path entryPath = new Path((CharSequence)entry.getName(), true);
            if (!entryPath.hasPrefix(zipPath) || entry.isDirectory()) continue;
            File file = new File(destPath, entryPath.getRelativePath(zipPath).getPath());
            file.getParentFile().mkdirs();
            BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
            Throwable throwable = null;
            try {
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    Throwable throwable2 = null;
                    try {
                        IOHelper.copyStream((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    file.setLastModified(entry.getTime());
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
    }

    class ZipFileBuilder {
        private final ZipOutputStream zos;
        private final File zipFile;

        ZipFileBuilder(File zipFile) throws FileNotFoundException {
            this.zipFile = zipFile;
            this.zos = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile));
        }

        ZipFileBuilder addFolder(String folderPath) throws IOException {
            this.zos.putNextEntry(new ZipEntry(folderPath));
            return this;
        }

        ZipFileBuilder addFile(String filePath) throws IOException {
            this.zos.putNextEntry(new ZipEntry(filePath));
            IOHelper.copyStream((InputStream)new ByteArrayInputStream(filePath.getBytes()), (OutputStream)this.zos);
            return this;
        }

        ZipFile build() throws IOException {
            this.zos.close();
            return new ZipFile(this.zipFile);
        }
    }
}

